/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.nbt;

import com.shanebeestudios.skbee.api.nbt.NBTChunk;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import com.shanebeestudios.skbee.api.nbt.NBTCustom;
import com.shanebeestudios.skbee.api.nbt.NBTType;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;

public class NBTCustomBlock
extends NBTContainer
implements NBTCustom {
    private final Block block;
    private final String blockTag;
    private final String blockID;
    private final NBTCompound chunkData;
    private boolean canSave;

    public NBTCustomBlock(Block block) {
        this.block = block;
        this.blockTag = String.format("%s_%s_%s", block.getX(), block.getY(), block.getZ());
        this.blockID = block.getType().getKey().toString();
        this.chunkData = new NBTChunk(block.getChunk()).getPersistentDataContainer();
        if (this.chunkData.hasTag("blocks", NBTType.NBTTagCompound)) {
            NBTCompound blocksInChunk = this.chunkData.getOrCreateCompound("blocks");
            if (this.block.getType().isAir()) {
                this.canSave = true;
                blocksInChunk.removeKey(this.blockTag);
                if (blocksInChunk.getKeys().isEmpty()) {
                    this.chunkData.removeKey("blocks");
                }
            } else if (blocksInChunk.hasTag(this.blockTag)) {
                NBTCompound blockCompound = blocksInChunk.getOrCreateCompound(this.blockTag);
                this.mergeCompound(blockCompound);
            }
        }
        this.canSave = true;
    }

    @Override
    protected void saveCompound() {
        if (!this.canSave) {
            return;
        }
        if (this.block.getType().isAir()) {
            this.clearNBT();
        }
        if (this.getKeys().isEmpty()) {
            if (this.chunkData.hasTag("blocks", NBTType.NBTTagCompound)) {
                NBTCompound blocksInChunk = this.chunkData.getOrCreateCompound("blocks");
                blocksInChunk.removeKey(this.blockTag);
                if (blocksInChunk.getKeys().isEmpty()) {
                    this.chunkData.removeKey("blocks");
                }
            }
            return;
        }
        NBTCompound blocksInChunk = this.chunkData.getOrCreateCompound("blocks");
        NBTCompound blockCompound = blocksInChunk.getOrCreateCompound(this.blockTag);
        blockCompound.clearNBT();
        blockCompound.mergeCompound(this);
    }

    @Override
    public String toString() {
        NBTContainer tag = new NBTContainer();
        tag.mergeCompound(this);
        tag.setString("id", this.blockID);
        tag.setInteger("x", this.block.getX());
        tag.setInteger("y", this.block.getY());
        tag.setInteger("z", this.block.getZ());
        return tag.toString();
    }

    @Override
    public void deleteCustomNBT() {
        this.removeKey("custom");
    }

    @Override
    @NotNull
    public NBTCompound getCopy() {
        NBTContainer emptyContainer = new NBTContainer();
        emptyContainer.mergeCompound(this);
        return emptyContainer;
    }

    @Override
    @NotNull
    public NBTCompound getCustomNBT() {
        NBTCompound custom = this.getOrCreateCompound("custom");
        if (this.hasTag("custom")) {
            return custom;
        }
        return new NBTContainer();
    }
}

