/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.nbt;

import ch.njol.util.StringUtils;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTType;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public enum NBTCustomType {
    NBTTagEnd("tag end", NBTType.NBTTagEnd),
    NBTTagByte("byte", NBTType.NBTTagByte, Byte.class),
    NBTTagShort("short", NBTType.NBTTagShort, Short.class),
    NBTTagInt("int", NBTType.NBTTagInt, Integer.class),
    NBTTagLong("long", NBTType.NBTTagLong, Long.class),
    NBTTagFloat("float", NBTType.NBTTagFloat, Float.class),
    NBTTagDouble("double", NBTType.NBTTagDouble, Double.class),
    NBTTagString("string", NBTType.NBTTagString, String.class),
    NBTTagCompound("compound", NBTType.NBTTagCompound, NBTCompound.class),
    NBTTagByteArray("byte array", NBTType.NBTTagByteArray, Number[].class),
    NBTTagIntArray("int array", NBTType.NBTTagIntArray, Number[].class),
    NBTTagDoubleList("double list", NBTType.NBTTagList, Number[].class),
    NBTTagFloatList("float list", NBTType.NBTTagList, Number[].class),
    NBTTagLongList("long list", NBTType.NBTTagList, Number[].class),
    NBTTagIntList("int list", NBTType.NBTTagList, Number[].class),
    NBTTagCompoundList("compound list", NBTType.NBTTagList, NBTCompound[].class),
    NBTTagStringList("string list", NBTType.NBTTagList, String[].class),
    NBTTagUUID("uuid", NBTType.NBTTagIntArray, Util.IS_RUNNING_SKRIPT_2_11 ? UUID.class : String.class),
    NBTTagBoolean("boolean", NBTType.NBTTagByte, Boolean.class);

    final String name;
    final NBTType nbtType;
    final Class<?> typeClass;
    private static final Map<String, NBTCustomType> BY_NAME;
    private static final Map<NBTType, NBTCustomType> BY_TYPE;

    private NBTCustomType(String name, NBTType nbtType) {
        this(name, nbtType, Void.class);
    }

    private NBTCustomType(String name, NBTType nbtType, Class<?> typeClass) {
        this.name = name + " tag";
        this.nbtType = nbtType;
        this.typeClass = typeClass;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public NBTType getNbtType() {
        return this.nbtType;
    }

    @Nullable
    public static NBTCustomType fromName(String name) {
        String s = name.toLowerCase(Locale.ROOT);
        if (BY_NAME.containsKey(s)) {
            return BY_NAME.get(s);
        }
        return null;
    }

    @Nullable
    public static NBTCustomType getByTag(NBTCompound compound, String key) {
        if (compound == null) {
            return null;
        }
        NBTType nbtType = compound.getType(key);
        if (BY_TYPE.containsKey((Object)nbtType)) {
            if (nbtType == NBTType.NBTTagList) {
                return switch (compound.getListType(key)) {
                    case NBTType.NBTTagInt -> NBTTagIntList;
                    case NBTType.NBTTagLong -> NBTTagLongList;
                    case NBTType.NBTTagFloat -> NBTTagFloatList;
                    case NBTType.NBTTagDouble -> NBTTagDoubleList;
                    case NBTType.NBTTagString -> NBTTagStringList;
                    case NBTType.NBTTagCompound -> NBTTagCompoundList;
                    default -> null;
                };
            }
            return BY_TYPE.get((Object)nbtType);
        }
        return null;
    }

    public static String getNames() {
        ArrayList<String> names = new ArrayList<String>(BY_NAME.keySet());
        Collections.sort(names);
        return StringUtils.join(names, (String)", ");
    }

    static {
        BY_NAME = new HashMap<String, NBTCustomType>();
        BY_TYPE = new HashMap<NBTType, NBTCustomType>();
        for (NBTCustomType type : NBTCustomType.values()) {
            if (type != NBTTagEnd) {
                BY_NAME.put(type.name, type);
            }
            if (BY_TYPE.containsKey((Object)type.nbtType)) continue;
            BY_TYPE.put(type.nbtType, type);
        }
    }
}

