/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.recipe;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.test.runner.TestMode;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.slot.Slot;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.elements.recipe.sections.SecRecipeSmithing;
import io.papermc.paper.potion.PotionMix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.jetbrains.annotations.Nullable;

public class RecipeUtil {
    public static final boolean HAS_CATEGORY = Skript.classExists((String)"org.bukkit.inventory.recipe.CraftingBookCategory");
    private static final Map<String, CraftingBookCategory> CATEGORY_MAP = new HashMap<String, CraftingBookCategory>();

    @Nullable
    public static RecipeChoice getRecipeChoice(Object object) {
        Tag tag;
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            Material material = itemStack.getType();
            if (!material.isItem() || material.isAir()) {
                return null;
            }
            if (itemStack.isSimilar(new ItemStack(material))) {
                return new RecipeChoice.MaterialChoice(material);
            }
            return new RecipeChoice.ExactChoice(itemStack);
        }
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            return RecipeUtil.getRecipeChoice(slot.getItem());
        }
        if (object instanceof ItemType) {
            ItemType itemType = (ItemType)object;
            return RecipeUtil.getRecipeChoice(itemType.getRandom());
        }
        if (object instanceof RecipeChoice) {
            RecipeChoice choice = (RecipeChoice)object;
            return choice;
        }
        if (object instanceof Tag && Util.isMaterialTag(tag = (Tag)object)) {
            return new RecipeChoice.MaterialChoice(tag);
        }
        return null;
    }

    public static void removeAllMCRecipes() {
        try {
            ArrayList recipes = new ArrayList();
            Bukkit.recipeIterator().forEachRemaining(recipe -> {
                if (recipe instanceof Keyed && !((Keyed)recipe).getKey().getNamespace().equalsIgnoreCase("minecraft")) {
                    recipes.add(recipe);
                }
            });
            Bukkit.clearRecipes();
            recipes.forEach(Bukkit::addRecipe);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static CraftingBookCategory getCraftingBookCategory(String name) {
        return CATEGORY_MAP.get(name);
    }

    public static void logRecipe(Recipe recipe, RecipeChoice ... ingredients) {
        if (!SkBee.isDebug() || TestMode.DEV_MODE) {
            return;
        }
        if (!(recipe instanceof Keyed)) {
            return;
        }
        RecipeUtil.log("&aRegistered new recipe: &7(&b%s&7)", ((Keyed)recipe).getKey().toString());
        RecipeUtil.log(" - &7Result: &e%s", recipe.getResult());
        RecipeUtil.log(" - &7Ingredients:");
        for (RecipeChoice ingredient : ingredients) {
            RecipeUtil.log("   - %s", RecipeUtil.getFancy(ingredient));
        }
    }

    public static void logCookingRecipe(CookingRecipe<?> recipe) {
        if (!SkBee.isDebug() || TestMode.DEV_MODE) {
            return;
        }
        String type = recipe.getClass().getSimpleName().replace("Recipe", "").toLowerCase(Locale.ROOT);
        RecipeUtil.log("&aRegistered new %s recipe: &7(&b%s&7)", type, recipe.getKey().toString());
        RecipeUtil.log(" - &7Result: &e%s", recipe.getResult());
        String group = recipe.getGroup();
        if (!group.isEmpty()) {
            RecipeUtil.log(" - &7Group: &r\"&6%s&r\"", group);
        }
        if (HAS_CATEGORY) {
            RecipeUtil.log(" - &7Category: &r\"&6%s&r\"", recipe.getCategory().name().toLowerCase(Locale.ROOT));
        }
        RecipeUtil.log(" - &7CookTime: &b%s", new Timespan(Timespan.TimePeriod.TICK, (long)recipe.getCookingTime()));
        RecipeUtil.log(" - &7Experience: &b%s", Float.valueOf(recipe.getExperience()));
        RecipeUtil.log(" - &7Ingredients: %s", RecipeUtil.getFancy(recipe.getInputChoice()));
    }

    public static void logShapelessRecipe(ShapelessRecipe recipe) {
        if (!SkBee.isDebug() || TestMode.DEV_MODE) {
            return;
        }
        RecipeUtil.log("&aRegistered new shapeless recipe: &7(&b%s&7)", recipe.getKey().toString());
        RecipeUtil.log(" - &7Result: &e%s", recipe.getResult());
        String group = recipe.getGroup();
        if (!group.isEmpty()) {
            RecipeUtil.log(" - &7Group: &r\"&6%s&r\"", group);
        }
        if (HAS_CATEGORY) {
            RecipeUtil.log(" - &7Category: &r\"&6%s&r\"", recipe.getCategory().name().toLowerCase(Locale.ROOT));
        }
        RecipeUtil.log(" - &7Ingredients:");
        recipe.getChoiceList().forEach(recipeChoice -> RecipeUtil.log("   - %s", RecipeUtil.getFancy(recipeChoice)));
    }

    public static void logShapedRecipe(ShapedRecipe recipe) {
        if (!SkBee.isDebug() || TestMode.DEV_MODE) {
            return;
        }
        RecipeUtil.log("&aRegistered new shaped recipe: &7(&b%s&7)", recipe.getKey().toString());
        RecipeUtil.log(" - &7Result: &e%s", recipe.getResult());
        String group = recipe.getGroup();
        if (!group.isEmpty()) {
            RecipeUtil.log(" - &7Group: &r\"&6%s&r\"", group);
        }
        if (HAS_CATEGORY) {
            RecipeUtil.log(" - &7Category: &r\"&6%s&r\"", recipe.getCategory().name().toLowerCase(Locale.ROOT));
        }
        String[] shape = recipe.getShape();
        StringJoiner joiner = new StringJoiner("&r], &r[&d", "&r[&d", "&r]");
        for (String s : shape) {
            joiner.add(s);
        }
        RecipeUtil.log(" - &7Shape: &r%s&7", joiner.toString());
        RecipeUtil.log(" - &7Ingredients:");
        recipe.getChoiceMap().forEach((character, recipeChoice) -> {
            if (recipeChoice != null) {
                RecipeUtil.log("   - &r'&d%s&r' = %s", character, RecipeUtil.getFancy(recipeChoice));
            }
        });
    }

    public static void logBrewingRecipe(PotionMix potionMix) {
        if (!SkBee.isDebug() || TestMode.DEV_MODE) {
            return;
        }
        RecipeUtil.log("&aRegistered new shaped recipe: &7(&b%s&7)", potionMix.getKey().toString());
        RecipeUtil.log(" - &7Result: &e%s", potionMix.getResult());
        RecipeUtil.log(" - &7Ingredient: %s", RecipeUtil.getFancy(potionMix.getIngredient()));
        RecipeUtil.log(" - &7Input: %s", RecipeUtil.getFancy(potionMix.getInput()));
    }

    public static void logSmithingRecipe(SmithingTransformRecipe recipe) {
        if (!SkBee.isDebug() || TestMode.DEV_MODE) {
            return;
        }
        RecipeUtil.log("&aRegistered new smithing recipe: &7(&b%s&7)", recipe.getKey().toString());
        RecipeUtil.log(" - &7Result: &e%s", recipe.getResult());
        RecipeUtil.log(" - &7Template: %s", RecipeUtil.getFancy(recipe.getTemplate()));
        RecipeUtil.log(" - &7Base: %s", RecipeUtil.getFancy(recipe.getBase()));
        RecipeUtil.log(" - &7Addition: %s", RecipeUtil.getFancy(recipe.getAddition()));
        if (SecRecipeSmithing.HAS_NBT_METHOD) {
            String copyNbt = recipe.willCopyNbt() ? "&atrue" : "&cfalse";
            RecipeUtil.log(" - &7CopyNbt: &e%s", copyNbt);
        }
    }

    public static void logTransmuteRecipe(TransmuteRecipe recipe) {
        if (!SkBee.isDebug() || TestMode.DEV_MODE) {
            return;
        }
        RecipeUtil.log("&aRegistering new transmute recipe: &7(&b%s&7)", recipe.getKey().toString());
        RecipeUtil.log(" - &7Result: &e%s", recipe.getResult().getType().getKey());
        RecipeUtil.log(" - &7Input: &e%s", RecipeUtil.getFancy(recipe.getInput()));
        RecipeUtil.log(" - &7Material: &e%s", RecipeUtil.getFancy(recipe.getMaterial()));
        RecipeUtil.log(" - &7Category: &r\"&6%s&r\"", recipe.getCategory().name().toLowerCase(Locale.ROOT));
        String group = recipe.getGroup();
        if (!group.isEmpty()) {
            RecipeUtil.log(" - &7Group: &r\"&6%s&r\"", group);
        }
    }

    private static String getFancy(RecipeChoice recipeChoice) {
        StringJoiner joiner = new StringJoiner("&r, &e", "&r[&e", "&r]");
        if (recipeChoice instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice;
            materialChoice.getChoices().forEach(material -> joiner.add(material.getKey().toString()));
        } else if (recipeChoice instanceof RecipeChoice.ExactChoice) {
            RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)recipeChoice;
            joiner.add(exactChoice.toString());
        }
        return joiner.toString();
    }

    public static void error(String error) {
        RecipeUtil.log("&c" + error);
        Util.errorForAdmins("Recipe error, see console for more details.", new Object[0]);
    }

    public static void warn(String warning) {
        RecipeUtil.log("&e" + warning);
    }

    public static void log(String log) {
        String prefix = "&7[&bRecipe&7] %s";
        Util.log(prefix, log);
    }

    public static void log(String format, Object ... objects) {
        RecipeUtil.log(String.format(format, objects));
    }

    static {
        for (CraftingBookCategory value : CraftingBookCategory.values()) {
            String name = value.name().toLowerCase(Locale.ROOT);
            CATEGORY_MAP.put(name, value);
        }
    }
}

