/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure;

import com.shanebeestudios.skbee.api.structure.StructureWrapper;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.structure.Structure;

public class StructureManager {
    private final Map<String, StructureWrapper> STRUCTURE_MAP = new HashMap<String, StructureWrapper>();
    private final org.bukkit.structure.StructureManager BUKKIT_STRUCTURE_MANAGER = Bukkit.getStructureManager();

    public StructureWrapper getStructure(String name) {
        if (this.STRUCTURE_MAP.containsKey(name)) {
            StructureWrapper structureWrapper = this.STRUCTURE_MAP.get(name);
            structureWrapper.reset();
            return structureWrapper;
        }
        NamespacedKey namespacedKey = Util.getNamespacedKey(name, true);
        if (namespacedKey == null) {
            return null;
        }
        Structure structure = this.BUKKIT_STRUCTURE_MANAGER.loadStructure(namespacedKey, true);
        if (structure == null) {
            structure = this.BUKKIT_STRUCTURE_MANAGER.createStructure();
            this.BUKKIT_STRUCTURE_MANAGER.registerStructure(namespacedKey, structure);
        }
        StructureWrapper structureWrapper = StructureWrapper.wrap(structure, namespacedKey);
        this.STRUCTURE_MAP.put(name, structureWrapper);
        return structureWrapper;
    }

    public void deleteStructure(StructureWrapper structure) {
        this.STRUCTURE_MAP.remove(structure.getName());
        structure.delete();
    }

    public boolean structureExists(String name) {
        NamespacedKey namespacedKey = Util.getNamespacedKey(name, true);
        if (namespacedKey == null) {
            return false;
        }
        return this.BUKKIT_STRUCTURE_MANAGER.loadStructure(namespacedKey, false) != null;
    }
}

