/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.util.SkriptColor;
import ch.njol.skript.util.slot.Slot;
import net.kyori.adventure.text.format.TextColor;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Translatable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum ChatUtil {
    BLACK(SkriptColor.BLACK, ChatColor.BLACK),
    DARK_GRAY(SkriptColor.DARK_GREY, ChatColor.DARK_GRAY),
    GRAY(SkriptColor.LIGHT_GREY, ChatColor.GRAY),
    WHITE(SkriptColor.WHITE, ChatColor.WHITE),
    DARK_BLUE(SkriptColor.DARK_BLUE, ChatColor.DARK_BLUE),
    BLUE(SkriptColor.BROWN, ChatColor.BLUE),
    DARK_AQUA(SkriptColor.DARK_CYAN, ChatColor.DARK_AQUA),
    AQUA(SkriptColor.LIGHT_CYAN, ChatColor.AQUA),
    DARK_GREEN(SkriptColor.DARK_GREEN, ChatColor.DARK_GREEN),
    GREEN(SkriptColor.LIGHT_GREEN, ChatColor.GREEN),
    YELLOW(SkriptColor.YELLOW, ChatColor.YELLOW),
    GOLD(SkriptColor.ORANGE, ChatColor.GOLD),
    DARK_RED(SkriptColor.DARK_RED, ChatColor.DARK_RED),
    RED(SkriptColor.LIGHT_RED, ChatColor.RED),
    DARK_PURPLE(SkriptColor.DARK_PURPLE, ChatColor.DARK_PURPLE),
    LIGHT_PURPLE(SkriptColor.LIGHT_PURPLE, ChatColor.LIGHT_PURPLE);

    private final SkriptColor skriptColor;
    private final ChatColor bungeeChatColor;

    private ChatUtil(SkriptColor skript, ChatColor bungee) {
        this.skriptColor = skript;
        this.bungeeChatColor = bungee;
    }

    @Nullable
    public static SkriptColor getSkriptColorByBungee(ChatColor chatColor) {
        for (ChatUtil value : ChatUtil.values()) {
            if (chatColor != value.bungeeChatColor) continue;
            return value.skriptColor;
        }
        return null;
    }

    public static TextColor getTextColorFromColor(ch.njol.skript.util.Color color) {
        return TextColor.color((int)color.asBukkitColor().asRGB());
    }

    @Nullable
    public static SkriptColor getSkriptColorFromTextColor(TextColor textColor) {
        int intValue = textColor.value();
        return SkriptColor.fromBukkitColor((Color)Color.fromRGB((int)intValue));
    }

    @Nullable
    public static String getTranslation(Object object) {
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            EntityType type = entity.getType();
            return Bukkit.getUnsafe().getTranslationKey(type);
        }
        if (object instanceof EntityData) {
            EntityData entityData = (EntityData)object;
            EntityType type = EntityUtils.toBukkitEntityType((EntityData)entityData);
            return Bukkit.getUnsafe().getTranslationKey(type);
        }
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            return itemStack.getType().translationKey();
        }
        if (object instanceof ItemType) {
            ItemType itemType = (ItemType)object;
            return itemType.getMaterial().translationKey();
        }
        if (object instanceof BlockData) {
            BlockData blockData = (BlockData)object;
            return blockData.getMaterial().translationKey();
        }
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            if (slot.getItem() == null) {
                return null;
            }
            return slot.getItem().translationKey();
        }
        if (object instanceof String) {
            String string = (String)object;
            return string;
        }
        if (object instanceof net.kyori.adventure.translation.Translatable) {
            net.kyori.adventure.translation.Translatable translatable = (net.kyori.adventure.translation.Translatable)object;
            return translatable.translationKey();
        }
        if (object instanceof Translatable) {
            Translatable translatable = (Translatable)object;
            return translatable.getTranslationKey();
        }
        return null;
    }
}

