/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util;

import ch.njol.skript.classes.Changer;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.PotionContents;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemComponentUtils {
    public static <T> void modifyComponent(Object[] objects, Changer.ChangeMode mode, @NotNull DataComponentType.Valued<T> type, @Nullable T value) {
        ItemUtils.modifyItems(objects, itemStack -> {
            if (mode == Changer.ChangeMode.SET && value != null) {
                itemStack.setData(type, value);
            } else if (mode == Changer.ChangeMode.DELETE) {
                itemStack.unsetData((DataComponentType)type);
            } else if (mode == Changer.ChangeMode.RESET) {
                itemStack.resetData((DataComponentType)type);
            }
        });
    }

    public static PotionType getPotionType(ItemStack itemStack) {
        PotionContents data;
        if (itemStack.hasData((DataComponentType)DataComponentTypes.POTION_CONTENTS) && (data = (PotionContents)itemStack.getData(DataComponentTypes.POTION_CONTENTS)) != null) {
            return data.potion();
        }
        return null;
    }

    public static void setPotionType(ItemStack itemStack, @Nullable PotionType potionType) {
        if (potionType != null) {
            PotionContents potionContents = (PotionContents)PotionContents.potionContents().potion(potionType).build();
            itemStack.setData(DataComponentTypes.POTION_CONTENTS, (Object)potionContents);
        } else {
            itemStack.unsetData((DataComponentType)DataComponentTypes.POTION_CONTENTS);
        }
    }

    public static Component getItemName(ItemStack itemStack, boolean itemName) {
        DataComponentType.Valued type;
        DataComponentType.Valued valued = type = itemName ? DataComponentTypes.ITEM_NAME : DataComponentTypes.CUSTOM_NAME;
        if (itemStack.hasData((DataComponentType)type)) {
            return (Component)itemStack.getData(type);
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        return itemName ? itemMeta.itemName() : itemMeta.displayName();
    }

    public static void setItemName(ItemStack itemStack, @Nullable Component name, boolean itemName) {
        DataComponentType.Valued type;
        DataComponentType.Valued valued = type = itemName ? DataComponentTypes.ITEM_NAME : DataComponentTypes.CUSTOM_NAME;
        if (name == null) {
            itemStack.resetData((DataComponentType)type);
        } else {
            itemStack.setData(type, (Object)name);
        }
    }
}

