/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.BukkitUnsafe;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.StringUtils;
import com.shanebeestudios.skbee.SkBee;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Nullable;

public abstract class ObjectConverter<T> {
    private static final Map<Class<?>, ObjectConverter<?>> CONVERTERS = new HashMap();

    private static <E> void register(Class<E> c, ObjectConverter<E> converter) {
        CONVERTERS.put(c, converter);
    }

    private static <E extends Keyed> void register(Class<E> c, final Registry<E> registry) {
        ObjectConverter objectConverter = new ObjectConverter<E>(){

            @Override
            public E get(NamespacedKey key) {
                return registry.get(key);
            }
        };
        CONVERTERS.put(c, objectConverter);
    }

    public static ObjectConverter<?> getFromClass(Class<?> c) {
        return CONVERTERS.get(c);
    }

    public static String getAllNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> aClass : CONVERTERS.keySet()) {
            ClassInfo exactClassInfo = Classes.getExactClassInfo(aClass);
            if (exactClassInfo == null) continue;
            String docName = exactClassInfo.getDocName();
            names.add(docName);
        }
        Collections.sort(names);
        return StringUtils.join(names, (String)", ");
    }

    @Nullable
    public abstract T get(NamespacedKey var1);

    static {
        ObjectConverter.register(Advancement.class, new ObjectConverter<Advancement>(){

            @Override
            @Nullable
            public Advancement get(NamespacedKey key) {
                return Bukkit.getAdvancement((NamespacedKey)key);
            }
        });
        ObjectConverter.register(Attribute.class, Registry.ATTRIBUTE);
        ObjectConverter.register(Biome.class, Registry.BIOME);
        if (Skript.classExists((String)"org.bukkit.damage.DamageType")) {
            ObjectConverter.register(DamageType.class, Registry.DAMAGE_TYPE);
        }
        ObjectConverter.register(Enchantment.class, Registry.ENCHANTMENT);
        ObjectConverter.register(EntityData.class, new ObjectConverter<EntityData>(){

            @Override
            public EntityData<?> get(NamespacedKey key) {
                EntityType entityType = (EntityType)Registry.ENTITY_TYPE.get(key);
                if (entityType != null) {
                    return EntityUtils.toSkriptEntityData((EntityType)entityType);
                }
                return null;
            }
        });
        ObjectConverter.register(EntityType.class, Registry.ENTITY_TYPE);
        ObjectConverter.register(GameEvent.class, Registry.GAME_EVENT);
        ObjectConverter.register(ItemType.class, new ObjectConverter<ItemType>(){

            @Override
            public ItemType get(NamespacedKey key) {
                Material mat = BukkitUnsafe.getMaterialFromMinecraftId((String)key.toString());
                if (mat != null) {
                    return new ItemType(mat);
                }
                return null;
            }
        });
        ObjectConverter.register(JukeboxSong.class, Registry.JUKEBOX_SONG);
        ObjectConverter.register(LootTable.class, new ObjectConverter<LootTable>(){

            @Override
            @Nullable
            public LootTable get(NamespacedKey key) {
                return Bukkit.getLootTable((NamespacedKey)key);
            }
        });
        ObjectConverter.register(MusicInstrument.class, Registry.INSTRUMENT);
        if (Skript.methodExists(Particle.class, (String)"getKey", (Class[])new Class[0])) {
            ObjectConverter.register(Particle.class, Registry.PARTICLE_TYPE);
        }
        ObjectConverter.register(PotionEffectType.class, new ObjectConverter<PotionEffectType>(){

            @Override
            public PotionEffectType get(NamespacedKey key) {
                return PotionEffectType.getByKey((NamespacedKey)key);
            }
        });
        ObjectConverter.register(PotionType.class, Registry.POTION);
        if (SkBee.getPlugin().getPluginConfig().ELEMENTS_STATISTIC) {
            ObjectConverter.register(Statistic.class, Registry.STATISTIC);
        }
        if (Skript.methodExists(Bukkit.class, (String)"getWorld", (Class[])new Class[]{NamespacedKey.class})) {
            ObjectConverter.register(World.class, new ObjectConverter<World>(){

                @Override
                public World get(NamespacedKey key) {
                    return Bukkit.getWorld((NamespacedKey)key);
                }
            });
        }
    }
}

