/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util.update;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Version;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.region.TaskUtils;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.util.update.ModrinthVersion;
import com.shanebeestudios.skbee.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final SkBee plugin;
    private final Version pluginVersion;
    private final Version serverVersion = Skript.getMinecraftVersion();
    private ModrinthVersion currentUpdateVersion;

    public UpdateChecker(SkBee plugin) {
        this.plugin = plugin;
        this.pluginVersion = new Version(plugin.getDescription().getVersion());
        Config config = plugin.getPluginConfig();
        if (config.SETTINGS_UPDATE_CHECKER_ENABLED) {
            this.setupJoinListener();
            this.checkUpdate(config.SETTINGS_UPDATE_CHECKER_ASYNC);
        } else {
            Util.log("&3Update checker disabled!", new Object[0]);
        }
    }

    private void setupJoinListener() {
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            private void onJoin(PlayerJoinEvent event) {
                Player player = event.getPlayer();
                if (!player.hasPermission("skbee.update.check")) {
                    return;
                }
                TaskUtils.getEntityScheduler((Entity)player).runTaskLater(() -> UpdateChecker.this.getUpdateVersion(true).thenApply(version -> {
                    Util.sendColMsg((CommandSender)player, "&7[&bSk&3Bee&7] Update available: &a" + String.valueOf(version.getUpdateVersion()), new Object[0]);
                    Util.sendColMsg((CommandSender)player, "&7[&bSk&3Bee&7] Download at: &b" + version.getUpdateLink(), new Object[0]);
                    return true;
                }), 30L);
            }
        }, (Plugin)this.plugin);
    }

    private void checkUpdate(boolean async) {
        Util.log("Checking for update...", new Object[0]);
        ((CompletableFuture)this.getUpdateVersion(async).thenApply(modrinthVersion -> {
            Util.logLoading("&cPlugin is not up to date!", new Object[0]);
            Util.logLoading(" - Current version: &cv%s", this.pluginVersion);
            Util.logLoading(" - Available update: &av%s", modrinthVersion.getUpdateVersion());
            if (modrinthVersion.isServerSupported(this.serverVersion)) {
                Util.logLoading(" - Download at: &b" + modrinthVersion.getUpdateLink(), new Object[0]);
            } else {
                Util.logLoading(" - &cYour server version &7(&e%s&7) &cdoes not support this update.", this.serverVersion);
                Util.logLoading(" - Supported Versions:", new Object[0]);
                for (Version supportedVersion : modrinthVersion.getSupportedVersions()) {
                    Util.logLoading("   - " + supportedVersion.toString(), new Object[0]);
                }
            }
            return true;
        })).exceptionally(throwable -> {
            Util.logLoading("&aPlugin is up to date!", new Object[0]);
            return true;
        });
    }

    private CompletableFuture<ModrinthVersion> getUpdateVersion(boolean async) {
        CompletableFuture<ModrinthVersion> updateVersionFuture = new CompletableFuture<ModrinthVersion>();
        if (this.currentUpdateVersion != null) {
            updateVersionFuture.complete(this.currentUpdateVersion);
        } else {
            CompletableFuture<ModrinthVersion> latestReleaseFuture = new CompletableFuture<ModrinthVersion>();
            if (async) {
                TaskUtils.getGlobalScheduler().runTaskAsync(() -> {
                    ModrinthVersion lastest = this.getLatestVersionFromModrinth();
                    if (lastest == null) {
                        latestReleaseFuture.cancel(true);
                    }
                    latestReleaseFuture.complete(lastest);
                });
            } else {
                ModrinthVersion latest = this.getLatestVersionFromModrinth();
                if (latest == null) {
                    latestReleaseFuture.cancel(true);
                }
                latestReleaseFuture.complete(latest);
            }
            latestReleaseFuture.thenApply(version -> {
                if (version.getUpdateVersion().compareTo(this.pluginVersion) <= 0) {
                    updateVersionFuture.cancel(true);
                } else {
                    this.currentUpdateVersion = version;
                    updateVersionFuture.complete(this.currentUpdateVersion);
                }
                return true;
            });
        }
        return updateVersionFuture;
    }

    private ModrinthVersion getLatestVersionFromModrinth() {
        try {
            URL url = new URL("https://api.modrinth.com/v2/project/a0tlbHZO/version");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            JsonArray elements = (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class);
            JsonElement latestVersion = elements.get(0);
            return new ModrinthVersion(latestVersion);
        }
        catch (IOException e) {
            if (SkBee.isDebug()) {
                e.printStackTrace();
            } else {
                Util.logLoading("&cChecking for update failed!", new Object[0]);
            }
            return null;
        }
    }
}

