/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.wrapper;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.comparator.Comparators;
import org.skriptlang.skript.lang.comparator.Relation;

public final class EnumWrapper<E extends Enum<E>> {
    private final Class<E> enumClass;
    private final String[] names;
    private final HashMap<String, E> parseMap = new HashMap();

    public EnumWrapper(@NotNull Class<E> enumClass, @Nullable String prefix, @Nullable String suffix, boolean plurals) {
        assert (enumClass.isEnum());
        this.enumClass = enumClass;
        this.names = new String[((Enum[])enumClass.getEnumConstants()).length];
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            String namePlural;
            Object name = enumConstant.name().toLowerCase(Locale.ROOT);
            String string = namePlural = plurals ? (String)name + "s" : null;
            if (prefix != null && !((String)name).startsWith(prefix)) {
                name = prefix + "_" + (String)name;
            }
            if (suffix != null && !((String)name).endsWith(suffix)) {
                name = (String)name + "_" + suffix;
            }
            this.parseMap.put((String)name, enumConstant);
            if (namePlural != null) {
                this.parseMap.put(namePlural, enumConstant);
            }
            this.names[enumConstant.ordinal()] = name;
        }
        this.registerComparator(enumClass);
    }

    public EnumWrapper(@NotNull Class<E> c, @Nullable String prefix, @Nullable String suffix) {
        this(c, prefix, suffix, false);
    }

    public EnumWrapper(@NotNull Class<E> c, boolean plurals) {
        this(c, null, null, plurals);
    }

    public EnumWrapper(@NotNull Class<E> c) {
        this(c, null, null, false);
    }

    @Nullable
    public E parse(String s) {
        return (E)((Enum)this.parseMap.get(s.toLowerCase(Locale.ROOT).replace(" ", "_")));
    }

    public void replace(String toReplace, String replacement) {
        if (this.parseMap.containsKey(toReplace)) {
            Enum e = (Enum)this.parseMap.get(toReplace);
            replacement = replacement.replace(" ", "_");
            this.parseMap.put(replacement, e);
            this.parseMap.remove(toReplace);
            this.names[e.ordinal()] = replacement;
        }
    }

    public String toString(E e, int flags) {
        return this.names[((Enum)e).ordinal()];
    }

    private String getAllNames() {
        ArrayList names = new ArrayList();
        Collections.addAll(names, this.names);
        Collections.sort(names);
        return StringUtils.join(names, (String)", ");
    }

    @NotNull
    public ClassInfo<E> getClassInfo(String codeName) {
        return new ClassInfo(this.enumClass, codeName).usage(new String[]{this.getAllNames()}).parser(new EnumParser(this));
    }

    @NotNull
    public ClassInfo<E> getClassInfo(String codeName, Consumer<ClassInfo<E>> consumer) {
        ClassInfo classInfo = new ClassInfo(this.enumClass, codeName);
        consumer.accept(classInfo);
        if (classInfo.getUsage() == null) {
            classInfo.usage(new String[]{this.getAllNames()});
        }
        if (classInfo.getParser() == null) {
            classInfo.parser(new EnumParser(this));
        }
        return classInfo;
    }

    private void registerComparator(Class<E> c) {
        if (Comparators.exactComparatorExists(c, c)) {
            return;
        }
        Comparators.registerComparator(c, c, (o1, o2) -> Relation.get((boolean)o1.equals(o2)));
    }

    static class EnumParser<T extends Enum<T>>
    extends Parser<T> {
        private final EnumWrapper<T> enumWrapper;

        public EnumParser(EnumWrapper<T> enumWrapper) {
            this.enumWrapper = enumWrapper;
        }

        @Nullable
        public T parse(@NotNull String s, @NotNull ParseContext context) {
            return this.enumWrapper.parse(s);
        }

        @NotNull
        public String toString(T o, int flags) {
            return this.enumWrapper.toString(o, flags);
        }

        @NotNull
        public String toVariableNameString(T o) {
            return this.toString(o, 0);
        }
    }
}

