/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.advancement.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Advancement - Progress")
@Description(value={"Returns the advancement progress of a player."})
public class ExprAdvancementProgress
extends SimpleExpression<AdvancementProgress> {
    private Expression<Advancement> advancement;
    private Expression<Player> player;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.advancement = exprs[0];
        this.player = exprs[1];
        return true;
    }

    @Nullable
    protected AdvancementProgress[] get(Event event) {
        Advancement advancement = (Advancement)this.advancement.getSingle(event);
        if (advancement == null) {
            return null;
        }
        ArrayList<AdvancementProgress> progresses = new ArrayList<AdvancementProgress>();
        for (Player player : (Player[])this.player.getArray(event)) {
            progresses.add(player.getAdvancementProgress(advancement));
        }
        return progresses.toArray(new AdvancementProgress[0]);
    }

    public boolean isSingle() {
        return this.player.isSingle();
    }

    @NotNull
    public Class<? extends AdvancementProgress> getReturnType() {
        return AdvancementProgress.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "advancement progress of advancement " + this.advancement.toString(e, d) + " of " + this.player.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprAdvancementProgress.class, AdvancementProgress.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"advancement progress of %advancement% (for|of) %players%"});
    }
}

