/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Bound - From ID")
@Description(value={"Get a bound object from a bound ID"})
@Examples(value={"set {_b} to bound from id \"%player%.home\""})
@Since(value={"1.0.0"})
public class ExprBoundFromID
extends SimpleExpression<Bound> {
    private Expression<String> ids;
    private static final BoundConfig boundConfig;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.ids = exprs[0];
        return true;
    }

    protected Bound[] get(Event event) {
        ArrayList<Bound> bounds = new ArrayList<Bound>();
        for (String id : (String[])this.ids.getAll(event)) {
            Bound bound = boundConfig.getBoundFromID(id);
            if (bounds.contains(bound)) continue;
            bounds.add(bound);
        }
        return bounds.toArray(new Bound[0]);
    }

    public boolean getAnd() {
        return this.ids.getAnd();
    }

    public boolean isSingle() {
        return this.ids.isSingle();
    }

    @NotNull
    public Class<? extends Bound> getReturnType() {
        return Bound.class;
    }

    @NotNull
    public String toString(Event event, boolean debug) {
        return "bound[s] from id " + this.ids.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprBoundFromID.class, Bound.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"bound[s] (of|from|with) id[s] %strings%"});
        boundConfig = SkBee.getPlugin().getBoundConfig();
    }
}

