/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bound - Owners/Members")
@Description(value={"Represents the owners and members of a bound. Will be saved as UUIDs in the bound config."})
@Examples(value={"add player to bound members of bound with id \"spawn\"", "remove player from bound owners of bound with id \"spawn\"", "loop bound owners of bound with id \"beach\":", "\tif loop-offline player is online:", "\t\tteleport loop-offline player to spawn of world \"world\""})
@Since(value={"1.15.0"})
public class ExprBoundOwnerMember
extends SimpleExpression<OfflinePlayer> {
    private static final BoundConfig BOUND_CONFIG = SkBee.getPlugin().getBoundConfig();
    private Expression<Bound> bound;
    private boolean owners;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.bound = exprs[0];
        this.owners = parseResult.mark == 0;
        return true;
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        ArrayList uuids = new ArrayList();
        Bound bound = (Bound)this.bound.getSingle(e);
        if (bound == null) {
            return null;
        }
        if (this.owners) {
            bound.getOwners().forEach(owner -> uuids.add(owner.toString()));
        } else {
            bound.getMembers().forEach(member -> uuids.add(member.toString()));
        }
        ArrayList players = new ArrayList();
        uuids.forEach(uuid -> players.add(Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid))));
        return players.toArray(new OfflinePlayer[0]);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.SET, Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer[].class});
            default -> null;
        };
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Bound bound = (Bound)this.bound.getSingle(e);
        if (bound == null) {
            return;
        }
        switch (mode) {
            case DELETE: {
                if (this.owners) {
                    bound.clearOwners();
                    break;
                }
                bound.clearMembers();
                break;
            }
            case SET: {
                if (this.owners) {
                    bound.clearOwners();
                } else {
                    bound.clearMembers();
                }
            }
            case ADD: {
                for (Object player : delta) {
                    if (!(player instanceof OfflinePlayer)) continue;
                    UUID uuid = ((OfflinePlayer)player).getUniqueId();
                    if (this.owners) {
                        bound.addOwner(uuid);
                        continue;
                    }
                    bound.addMember(uuid);
                }
                break;
            }
            case REMOVE: {
                for (Object player : delta) {
                    if (!(player instanceof OfflinePlayer)) continue;
                    UUID uuid = ((OfflinePlayer)player).getUniqueId();
                    if (this.owners) {
                        bound.removeOwner(uuid);
                        continue;
                    }
                    bound.removeMember(uuid);
                }
                break;
            }
            default: {
                return;
            }
        }
        BOUND_CONFIG.saveBound(bound, false);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "bound " + (this.owners ? "owners" : "members") + " of bound " + this.bound.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBoundOwnerMember.class, OfflinePlayer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"bound (owner[s]|1:member[s]) of %bound%"});
    }
}

