/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Bound - Last Created Bound")
@Description(value={"Returns the last created bound."})
@Examples(value={"create a bound with id \"\" between {_pos1} and {_pos2}", "broadcast last created bound", "resize last created bound between {_pos1^2} and {_pos2^2}"})
@Since(value={"2.15.0"})
public class ExprLastCreatedBound
extends SimpleExpression<Bound> {
    private static final BoundConfig boundConfig = SkBee.getPlugin().getBoundConfig();
    public static Bound lastCreated;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Nullable
    protected Bound[] get(Event event) {
        if (lastCreated == null) {
            return null;
        }
        if (!boundConfig.boundExists(lastCreated.getId())) {
            lastCreated = null;
            return null;
        }
        return new Bound[]{lastCreated};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Bound> getReturnType() {
        return Bound.class;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "lastly created bound";
    }

    static {
        Skript.registerExpression(ExprLastCreatedBound.class, Bound.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] last[ly] created bound"});
        lastCreated = null;
    }
}

