/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.damagesource.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.damage.DamageSource;
import org.jetbrains.annotations.NotNull;

@Name(value="DamageSource - Property Conditions")
@Description(value={"Represents some conditions of a damage source."})
@Examples(value={"if damage source is indirect:", "if damage source is scaled with difficulty:"})
@Since(value={"3.3.0"})
public class CondDamageSourceProperties
extends PropertyCondition<DamageSource> {
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    public boolean check(DamageSource damageSource) {
        if (this.pattern == 1) {
            return damageSource.scalesWithDifficulty();
        }
        return damageSource.isIndirect();
    }

    @NotNull
    protected String getPropertyName() {
        return this.pattern == 1 ? "scaled with difficulty" : "indirect";
    }

    static {
        CondDamageSourceProperties.register(CondDamageSourceProperties.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (String)"(indirect|1:scaled with difficulty)", (String)"damagesources");
    }
}

