/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.damagesource.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="DamageSource - Damage Entity")
@Description(value={"Damage entities using a damage source. ", "This has the same functionality as Minecraft's `/damage` command.", "Requires MC 1.20.4+"})
@Examples(value={"set {_source} to damage source from arrow directly by (random element of all entities)", "set {_source} to damage source of dragon breath", "set {_source} to damage source of magic", "set {_source} to damage source of mob_attack_no_aggro caused by target entity of player", "damage player by 100 with {_source}"})
@Since(value={"3.3.0"})
public class EffEntityDamageSource
extends Effect {
    private Expression<Entity> entities;
    private Expression<Number> amount;
    private Expression<DamageSource> damageSource;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.amount = exprs[1];
        this.damageSource = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        DamageSource damageSource = (DamageSource)this.damageSource.getSingle(event);
        Number amountNum = (Number)this.amount.getSingle(event);
        if (damageSource == null || amountNum == null) {
            return;
        }
        double amount = amountNum.doubleValue();
        for (Entity entity : (Entity[])this.entities.getArray(event)) {
            if (!(entity instanceof Damageable)) continue;
            Damageable damageable = (Damageable)entity;
            damageable.damage(amount, damageSource);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "damage " + this.entities.toString(e, d) + " by " + this.amount.toString(e, d) + " with " + this.damageSource.toString(e, d);
    }

    static {
        Skript.registerEffect(EffEntityDamageSource.class, (String[])new String[]{"damage %entities% by %number% with %damagesource%"});
    }
}

