/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Glow Color Override")
@Description(value={"Represents the glow color override of a Display Entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display glow color override of {_display} to bukkitColor(255,1,1,100)"})
@Since(value={"2.8.0"})
public class ExprDisplayGlowColor
extends SimplePropertyExpression<Entity, Color> {
    @Nullable
    public Color convert(Entity entity) {
        if (entity instanceof Display) {
            Display display = (Display)entity;
            return display.getGlowColorOverride();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Color.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Color) {
            Color color = (Color)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof Display)) continue;
                Display display = (Display)entity;
                display.setGlowColorOverride(color);
            }
        }
    }

    @NotNull
    public Class<? extends Color> getReturnType() {
        return Color.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "glow color override";
    }

    static {
        ExprDisplayGlowColor.register(ExprDisplayGlowColor.class, Color.class, (String)"[display] glow color override", (String)"entities");
    }
}

