/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Display Width/Height")
@Description(value={"Represents the width/height of a display entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display width of {_display} to 3"})
@Since(value={"2.8.0"})
public class ExprDisplayWidthHeight
extends SimplePropertyExpression<Entity, Number> {
    private boolean height;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.height = parseResult.hasTag("height");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Entity entity) {
        if (!(entity instanceof Display)) {
            return null;
        }
        Display display = (Display)entity;
        return Float.valueOf(this.height ? display.getDisplayHeight() : display.getDisplayWidth());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number num = (Number)object;
            float changeValue = num.floatValue();
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof Display)) continue;
                Display display = (Display)entity;
                if (this.height) {
                    display.setDisplayHeight(changeValue);
                    continue;
                }
                display.setDisplayWidth(changeValue);
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display " + (this.height ? "height" : "width");
    }

    static {
        ExprDisplayWidthHeight.register(ExprDisplayWidthHeight.class, Number.class, (String)"display (width|height:height)", (String)"entities");
    }
}

