/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@Name(value="Quaternion - Values")
@Description(value={"Represents the x/y/z/w values of a quaternion."})
@Examples(value={"add 1 to quat-x of {_q}", "remove 1 from quat-x of {_q}", "reset quat-x of {_q}", "set {_x} to quat-x of display right rotation of {_display}"})
@Since(value={"2.8.2"})
public class ExprQuaternionElements
extends SimplePropertyExpression<Quaternionf, Number> {
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Quaternionf quaternionf) {
        return switch (this.pattern) {
            case 1 -> Float.valueOf(quaternionf.y);
            case 2 -> Float.valueOf(quaternionf.z);
            case 3 -> Float.valueOf(quaternionf.w);
            default -> Float.valueOf(quaternionf.x);
        };
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: 
            case RESET: {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            }
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        float f;
        Object object;
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number num = (Number)object;
            f = num.floatValue();
        } else {
            f = this.pattern == 3 ? 1.0f : 0.0f;
        }
        float changeValue = f;
        block14: for (Quaternionf quaternionf : (Quaternionf[])this.getExpr().getArray(event)) {
            float oldValue = switch (this.pattern) {
                case 1 -> quaternionf.y;
                case 2 -> quaternionf.z;
                case 3 -> quaternionf.w;
                default -> quaternionf.x;
            };
            switch (mode) {
                case ADD: {
                    changeValue += oldValue;
                    break;
                }
                case REMOVE: {
                    changeValue = oldValue - changeValue;
                }
            }
            switch (this.pattern) {
                case 1: {
                    quaternionf.y = changeValue;
                    continue block14;
                }
                case 2: {
                    quaternionf.z = changeValue;
                    continue block14;
                }
                case 3: {
                    quaternionf.w = changeValue;
                    continue block14;
                }
                default: {
                    quaternionf.x = changeValue;
                }
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        String value = switch (this.pattern) {
            case 1 -> "y";
            case 2 -> "z";
            case 3 -> "w";
            default -> "x";
        };
        return "quat-" + value;
    }

    static {
        ExprQuaternionElements.register(ExprQuaternionElements.class, Number.class, (String)"quat[ernion]-(x|1:y|2:z|3:w)", (String)"quaternions");
    }
}

