/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Text Component")
@Description(value={"Represents the text component of a Text Display Entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display component of {_display} to mini message from \"<rainbow>OOO A RAINBOW\""})
@Since(value={"2.8.0"})
public class ExprTextDisplayTextComponent
extends SimplePropertyExpression<Entity, ComponentWrapper> {
    @Nullable
    public ComponentWrapper convert(Entity entity) {
        if (entity instanceof TextDisplay) {
            TextDisplay textDisplay = (TextDisplay)entity;
            Component text = textDisplay.text();
            return ComponentWrapper.fromComponent(text);
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (delta != null && (object = delta[0]) instanceof ComponentWrapper) {
            ComponentWrapper componentWrapper = (ComponentWrapper)object;
            Component component = componentWrapper.getComponent();
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof TextDisplay)) continue;
                TextDisplay textDisplay = (TextDisplay)entity;
                textDisplay.text(component);
            }
        }
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display text component";
    }

    static {
        if (SkBee.getPlugin().getAddonLoader().isTextComponentEnabled()) {
            ExprTextDisplayTextComponent.register(ExprTextDisplayTextComponent.class, ComponentWrapper.class, (String)"display [text] component", (String)"entities");
        }
    }
}

