/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fastboard.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.fastboard.FastBoardBase;
import com.shanebeestudios.skbee.api.fastboard.FastBoardManager;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="FastBoard - Clear")
@Description(value={"Clear a fastboard of a player.", "NOTE: You do NOT need to clear a fastboard before changing lines."})
@Examples(value={"clear fastboard of all players", "clear fastboard of player"})
@Since(value={"1.16.0"})
public class EffFastBoardClear
extends Effect {
    private Expression<Player> player;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        if (parseResult.hasTag("score")) {
            Skript.warning((String)"'scoreboard' is deprecated, please use 'fastboard' instead.");
        }
        return true;
    }

    protected void execute(Event event) {
        for (Player player : (Player[])this.player.getArray(event)) {
            FastBoardBase<?, ?> board = FastBoardManager.getBoard(player);
            if (board == null) continue;
            board.clear();
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "clear fastboard[s] of " + this.player.toString(e, d);
    }

    static {
        Skript.registerEffect(EffFastBoardClear.class, (String[])new String[]{"clear [:score|fast]board[s] of %players%", "clear %players%'[s] [:score|fast]board[s]"});
    }
}

