/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fastboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.fastboard.FastBoardBase;
import com.shanebeestudios.skbee.api.fastboard.FastBoardManager;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="FastBoard - Title")
@Description(value={"Get/set the title of a fastboard.", "When running Paper, text components are supported."})
@Examples(value={"set title of player's fastboard to \"Le Title\"", "set {_title} to title of fastboard of player", "", "# Component Support", "set title of player's fastboard to mini message from \"<rainbow>Le Title\"", "set title of player's fastboard to mini message from \"<font:uniform>Le Title\""})
@Since(value={"1.16.0"})
public class ExprFastBoardTitle
extends SimpleExpression<Object> {
    private static final Class<?>[] CHANGE_TYPES;
    private Expression<Player> player;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        if (parseResult.hasTag("score")) {
            Skript.warning((String)"'scoreboard' is deprecated, please use 'fastboard' instead.");
        }
        return true;
    }

    @Nullable
    protected Object[] get(Event event) {
        ArrayList titles = new ArrayList();
        for (Player player : (Player[])this.player.getArray(event)) {
            FastBoardBase<?, ?> board = FastBoardManager.getBoard(player);
            if (board == null) continue;
            titles.add(board.getTitle());
        }
        return titles.toArray();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return CHANGE_TYPES;
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object title = delta != null ? delta[0] : null;
        for (Player player : (Player[])this.player.getArray(event)) {
            FastBoardBase<?, ?> board = FastBoardManager.getBoard(player);
            if (board == null) continue;
            board.setTitle(title);
        }
    }

    public boolean isSingle() {
        return this.player.isSingle();
    }

    @NotNull
    public Class<?> getReturnType() {
        return FastBoardManager.HAS_ADVENTURE ? ComponentWrapper.class : String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "title of fastboard of " + this.player.toString(e, d);
    }

    static {
        Class[] classArray;
        if (FastBoardManager.HAS_ADVENTURE) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = ComponentWrapper.class;
            classArray = classArray2;
            classArray2[1] = String.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = String.class;
        }
        CHANGE_TYPES = classArray;
        Skript.registerExpression(ExprFastBoardTitle.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"title of %players%'[s] [:score|fast]board[s]", "title of [:score|fast]board of %players%"});
    }
}

