/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fishing.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerFishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Fish Event State")
@Description(value={"Represents the state of a fishing event."})
@Examples(value={"on fish:", "\tif fish event state = caught fish:", "\t\tcancel event"})
@Since(value={"1.15.2"})
public class ExprFishEventState
extends SimpleExpression<PlayerFishEvent.State> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(PlayerFishEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in a fishing event"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    @Nullable
    protected PlayerFishEvent.State[] get(Event event) {
        if (!(event instanceof PlayerFishEvent)) {
            return null;
        }
        PlayerFishEvent playerFishEvent = (PlayerFishEvent)event;
        return new PlayerFishEvent.State[]{playerFishEvent.getState()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends PlayerFishEvent.State> getReturnType() {
        return PlayerFishEvent.State.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "fish event state";
    }

    static {
        Skript.registerExpression(ExprFishEventState.class, PlayerFishEvent.State.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"fish[ing] [event] state"});
    }
}

