/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fishing.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Fish Hook - Wait time")
@Description(value={"Represents the min/max wait time for a fish hook to catch a fish.", "\nNOTE: this is before applying lure.", "\nNOTE: min wait time must be less than max wait time. Both must be greater than 0.", "\nDefaults: min = 100 ticks (5 seconds), max = 600 ticks (30 seconds)."})
@Examples(value={"on fish:", "\tif fish state = fishing:", "\t\tset min wait time of fish hook to 1 second", "\t\tset max wait time of fish hook to 2 seconds"})
@Since(value={"2.8.0"})
public class ExprFishHookWaitTime
extends SimplePropertyExpression<Entity, Timespan> {
    private boolean max;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.max = parseResult.hasTag("max");
        return true;
    }

    @Nullable
    public Timespan convert(Entity entity) {
        if (entity instanceof FishHook) {
            FishHook fishHook = (FishHook)entity;
            int wait = this.max ? fishHook.getMaxWaitTime() : fishHook.getMinWaitTime();
            return new Timespan(Timespan.TimePeriod.TICK, (long)wait);
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.RESET, Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{Timespan.class});
            case Changer.ChangeMode.REMOVE_ALL, Changer.ChangeMode.DELETE -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int changeValue = delta != null && delta[0] != null ? (int)((Timespan)delta[0]).getAs(Timespan.TimePeriod.TICK) : 0;
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (!(entity instanceof FishHook)) continue;
            FishHook fishHook = (FishHook)entity;
            int value = this.max ? fishHook.getMaxWaitTime() : fishHook.getMinWaitTime();
            switch (mode) {
                case ADD: {
                    value += changeValue;
                    break;
                }
                case SET: {
                    value = changeValue;
                    break;
                }
                case RESET: {
                    value = this.max ? 600 : 100;
                    break;
                }
                case REMOVE: {
                    value -= changeValue;
                }
            }
            if (value < 0) {
                return;
            }
            if (this.max) {
                if (value < fishHook.getMinWaitTime()) {
                    fishHook.setMinWaitTime(value);
                }
                fishHook.setMaxWaitTime(value);
                continue;
            }
            if (value > fishHook.getMaxWaitTime()) {
                fishHook.setMaxWaitTime(value);
            }
            fishHook.setMinWaitTime(value);
        }
    }

    @NotNull
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "wait time";
    }

    static {
        ExprFishHookWaitTime.register(ExprFishHookWaitTime.class, Timespan.class, (String)"(min|:max) wait time", (String)"entities");
    }
}

