/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fishing.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerFishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Fishing - Experience")
@Description(value={"Get and modify the amount of experience dropped in a fishing event."})
@Examples(value={"on fishing:", "\tadd 10xp to fishing experience", "\tsend fishing experience to player"})
@Since(value={"2.14.0"})
public class ExprFishingExperience
extends SimpleExpression<Experience> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(PlayerFishEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in a fishing event"));
            return false;
        }
        return true;
    }

    @Nullable
    protected Experience[] get(Event event) {
        Experience experience = new Experience(((PlayerFishEvent)event).getExpToDrop());
        return new Experience[]{experience};
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Experience.class, Number.class});
            case Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!(event instanceof PlayerFishEvent)) {
            return;
        }
        PlayerFishEvent playerFishEvent = (PlayerFishEvent)event;
        if (delta == null) {
            playerFishEvent.setExpToDrop(0);
            return;
        }
        int experience = delta[0] instanceof Experience ? ((Experience)delta[0]).getXP() : ((Number)delta[0]).intValue();
        int curentExperience = playerFishEvent.getExpToDrop();
        int value = 0;
        switch (mode) {
            case SET: {
                value = experience;
                break;
            }
            case ADD: {
                value = curentExperience + experience;
                break;
            }
            case REMOVE: {
                value = curentExperience - experience;
                if (value >= 0) break;
                value = 0;
            }
        }
        playerFishEvent.setExpToDrop(value);
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Experience> getReturnType() {
        return Experience.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "fishing experience";
    }

    static {
        Skript.registerExpression(ExprFishingExperience.class, Experience.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"fish[ing] [event] experience"});
    }
}

