/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fishing.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PufferFish;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="PufferFish - Puff State")
@Description(value={"Represents the puff state of a puffer fish. An integer between 0 and 2"})
@Examples(value={"set puff state of target entity to 1", "add 1 to puff state of target entity", "reset puff state of target entity"})
@Since(value={"2.8.0"})
public class ExprPufferFishState
extends SimplePropertyExpression<Entity, Integer> {
    @Nullable
    public Integer convert(Entity entity) {
        if (entity instanceof PufferFish) {
            PufferFish pufferFish = (PufferFish)entity;
            return pufferFish.getPuffState();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Changer.ChangeMode.ADD, Changer.ChangeMode.SET, Changer.ChangeMode.RESET, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Integer.class});
            case Changer.ChangeMode.REMOVE_ALL, Changer.ChangeMode.DELETE -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int changer = delta != null && delta[0] != null ? (Integer)delta[0] : 0;
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (!(entity instanceof PufferFish)) continue;
            PufferFish pufferFish = (PufferFish)entity;
            int puffState = pufferFish.getPuffState();
            switch (mode) {
                case SET: {
                    puffState = changer;
                    break;
                }
                case ADD: {
                    puffState += changer;
                    break;
                }
                case REMOVE: {
                    puffState -= changer;
                    break;
                }
                case RESET: {
                    puffState = 0;
                }
            }
            if (puffState > 2) {
                puffState = 2;
            }
            if (puffState < 0) {
                puffState = 0;
            }
            pufferFish.setPuffState(puffState);
        }
    }

    @NotNull
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "puff state";
    }

    static {
        ExprPufferFishState.register(ExprPufferFishState.class, Integer.class, (String)"puff state", (String)"entities");
    }
}

