/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.gameevent.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import org.bukkit.GameEvent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockReceiveGameEvent;
import org.bukkit.event.world.GenericGameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converter;

public class EvtGameEvents
extends SkriptEvent {
    private Literal<GameEvent> gameEvents;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (args[0] != null) {
            this.gameEvents = args[0];
        }
        return true;
    }

    public boolean check(Event event) {
        if (event instanceof GenericGameEvent) {
            if (this.gameEvents != null) {
                GameEvent eventGameEvent = ((GenericGameEvent)event).getEvent();
                return this.gameEvents.check(event, gameEvent -> gameEvent == eventGameEvent);
            }
            return true;
        }
        if (event instanceof BlockReceiveGameEvent) {
            if (this.gameEvents != null) {
                GameEvent eventGameEvent = ((BlockReceiveGameEvent)event).getEvent();
                return this.gameEvents.check(event, gameEvent -> gameEvent == eventGameEvent);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "generic/block receive game event" + (String)(this.gameEvents != null ? " " + this.gameEvents.toString(e, d) : "");
    }

    static {
        Skript.registerEvent((String)"Generic Game Event", EvtGameEvents.class, GenericGameEvent.class, (String[])new String[]{"[generic] game[ ]event [%-gameevent%]"}).description(new String[]{"Called when a Minecraft game event is fired. These events are provided directly by Minecraft.", "NOTE: Cancelling this event will not cancel the action, only cancel broadcasting event to blocks.", "Requires MC 1.17+"}).examples(new String[]{"on game event splash:", "\tset {_e} to event-entity", "\tif {_e} is a player:", "\t\tpush {_e} up with speed 0.5"}).since("1.14.0");
        Skript.registerEvent((String)"Block Receive Game Event", EvtGameEvents.class, BlockReceiveGameEvent.class, (String[])new String[]{"block receive game[ ]event [%-gameevent%]"}).description(new String[]{"Called when a block receives a Minecraft game event.", "As of now the only block that receives game events are sculk shrieker, sculk sensor, and calibrated sculk sensor.", "Requires MC 1.17+"}).examples(new String[]{"on block receive game event:", "\tset {_e} to event-entity", "\tif {_e} is a player:", "\t\tif event-block is set:", "\t\t\tdamage {_e} by 0.5"}).since("1.14.0");
        EventValues.registerEventValue(GenericGameEvent.class, Entity.class, (Converter)new Converter<GenericGameEvent, Entity>(){

            @Nullable
            public Entity convert(GenericGameEvent event) {
                return event.getEntity();
            }
        }, (int)0);
        EventValues.registerEventValue(GenericGameEvent.class, GameEvent.class, GenericGameEvent::getEvent, (int)0);
        EventValues.registerEventValue(GenericGameEvent.class, Location.class, GenericGameEvent::getLocation, (int)0);
        EventValues.registerEventValue(GenericGameEvent.class, Player.class, event -> {
            Entity patt0$temp = event.getEntity();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                return player;
            }
            return null;
        }, (int)0);
        EventValues.registerEventValue(BlockReceiveGameEvent.class, Entity.class, BlockReceiveGameEvent::getEntity, (int)0);
        EventValues.registerEventValue(BlockReceiveGameEvent.class, GameEvent.class, BlockReceiveGameEvent::getEvent, (int)0);
        EventValues.registerEventValue(BlockReceiveGameEvent.class, Player.class, event -> {
            Entity patt0$temp = event.getEntity();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                return player;
            }
            return null;
        }, (int)0);
    }
}

