/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.generator.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.generator.event.BiomeGenEvent;
import com.shanebeestudios.skbee.api.generator.event.BlockPopulateEvent;
import com.shanebeestudios.skbee.api.generator.event.ChunkGenEvent;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import com.shanebeestudios.skbee.api.util.MathUtil;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.event.Event;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ChunkGenerator - ChunkData Biome")
@Description(value={"Represents the biome in ChunkData.", "The first pattern is used to set the biome in the `biome gen` section.", "The second pattern is used to retrieve biomes in the `chunk gen` and `block pop` sections.", "NOTE: The vector represents the position of the biome in the chunk, not the world."})
@Examples(value={"biome gen:", "\tset chunkdata biome to plains", "", "chunk gen:", "\tset {_biome} to chunkdata biome at vector(0,0,0)", "\tif {_biome} is plains:", "\t\tset chunkdata block at vector(0,0,0) to grass[]"})
@Since(value={"3.5.0"})
public class ExprChunkDataBiome
extends SimpleExpression<Biome> {
    private Expression<Vector> vector;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0 && !ParserInstance.get().isCurrentEvent(BiomeGenEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in biome gen sections."));
            return false;
        }
        if (matchedPattern == 1 && !ParserInstance.get().isCurrentEvent(new Class[]{ChunkGenEvent.class, BlockPopulateEvent.class})) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in chunk gen/block pop sections."));
            return false;
        }
        this.vector = matchedPattern == 1 ? exprs[0] : null;
        return true;
    }

    protected Biome @Nullable [] get(@NotNull Event event) {
        if (this.vector != null) {
            Vector vector = (Vector)this.vector.getSingle(event);
            if (vector == null) {
                return null;
            }
            int x = MathUtil.clamp(vector.getBlockX(), 0, 15);
            int y = vector.getBlockY();
            int z = MathUtil.clamp(vector.getBlockZ(), 0, 15);
            if (event instanceof ChunkGenEvent) {
                ChunkGenEvent chunkGenEvent = (ChunkGenEvent)event;
                ChunkGenerator.ChunkData chunkData = chunkGenEvent.getChunkData();
                Biome biome = chunkData.getBiome(x, y, z);
                return new Biome[]{biome};
            }
            if (event instanceof BlockPopulateEvent) {
                BlockPopulateEvent populateEvent = (BlockPopulateEvent)event;
                int chunkX = populateEvent.getChunkX();
                int chunkZ = populateEvent.getChunkZ();
                LimitedRegion limitedRegion = populateEvent.getLimitedRegion();
                y = ExprChunkDataBiome.clamp(limitedRegion, y);
                Biome biome = limitedRegion.getBiome((chunkX << 4) + x, y, (chunkZ << 4) + z);
                return new Biome[]{biome};
            }
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && this.vector == null) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Biome.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (mode == Changer.ChangeMode.SET && delta != null && (object = delta[0]) instanceof Biome) {
            Biome biome = (Biome)object;
            if (event instanceof BiomeGenEvent) {
                BiomeGenEvent biomeGenEvent = (BiomeGenEvent)event;
                biomeGenEvent.setBiome(biome);
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Biome> getReturnType() {
        return Biome.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String vector = this.vector != null ? " at " + this.vector.toString(e, d) : "";
        return "chunkdata biome" + vector;
    }

    private static int clamp(LimitedRegion limitedRegion, int y) {
        World world = limitedRegion.getWorld();
        int minHeight = world.getMinHeight();
        int maxHeight = world.getMaxHeight() - 1;
        return MathUtil.clamp(y, minHeight, maxHeight);
    }

    static {
        Skript.registerExpression(ExprChunkDataBiome.class, Biome.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"chunk[ ]data biome", "chunk[ ]data biome at %vector%"});
    }
}

