/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.generator.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.generator.event.HeightGenEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ChunkGenerator - ChunkData Height")
@Description(value={"Represents the highest point in a chunk used in a `height gen` section.", "This is used to tell Minecraft where the highest block is when it needs to generate structures."})
@Examples(value={"height gen:", "\tset {_x} to x coord of event-location", "\tset {_z} to z coord of event-location", "\tset {_n} to getNoise({_x}, {_z}) # This is just an example of a function you could do to get noise)", "\tset chunkdata height to {_n} + 1"})
@Since(value={"3.5.0"})
public class ExprChunkGenHeight
extends SimpleExpression<Number> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(HeightGenEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in a height gen section."));
            return false;
        }
        return true;
    }

    protected Number @Nullable [] get(Event event) {
        if (event instanceof HeightGenEvent) {
            HeightGenEvent heightGenEvent = (HeightGenEvent)event;
            return new Number[]{heightGenEvent.getHeight()};
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && event instanceof HeightGenEvent) {
            Object object;
            HeightGenEvent heightGenEvent = (HeightGenEvent)event;
            if (delta != null && (object = delta[0]) instanceof Number) {
                Number number = (Number)object;
                heightGenEvent.setHeight(number.intValue());
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "chunkdata height";
    }

    static {
        Skript.registerExpression(ExprChunkGenHeight.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"chunk[ ]data height"});
    }
}

