/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.ColorRGB;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.skript.base.SimplePropertyExpression;
import com.shanebeestudios.skbee.api.util.ItemComponentUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import org.bukkit.Color;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Dyed Color")
@Description(value={"Represents the dyed color component of an item.", "This will work on leather armor, or items that have a dye component on their item model.", "See [**ItemModel**](https://minecraft.wiki/w/Data_component_format#dyed_color) on McWiki for more details.", "Requires Paper 1.21.3+", "", "**Changers**:", "`set` = Will set the dyed color of the item.", "`delete` = Will delete the dyed color of this item.", "`reset` = Will reset the dyed color back to the original value."})
@Examples(value={"set dyed color of player's tool to red", "set dyed color of player's tool to rgb(255,100,3)", "set dyed color of player's tool to yellow", "delete dyed color of player's tool", "reset dyed color of {_item}"})
@Since(value={"3.9.0"})
public class ExprDyedColorComponent
extends SimplePropertyExpression<Object, ch.njol.skript.util.Color> {
    @Nullable
    public ch.njol.skript.util.Color convert(Object from) {
        DyedItemColor data;
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(from);
        if (itemStack != null && itemStack.hasData((DataComponentType)DataComponentTypes.DYED_COLOR) && (data = (DyedItemColor)itemStack.getData(DataComponentTypes.DYED_COLOR)) != null) {
            return ColorRGB.fromBukkitColor((Color)data.color());
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ch.njol.skript.util.Color.class});
        }
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        ch.njol.skript.util.Color col;
        Object object;
        ch.njol.skript.util.Color color = delta != null && (object = delta[0]) instanceof ch.njol.skript.util.Color ? (col = (ch.njol.skript.util.Color)object) : null;
        DyedItemColor dyedItemColor = null;
        if (color != null) {
            dyedItemColor = DyedItemColor.dyedItemColor((Color)color.asBukkitColor());
        }
        ItemComponentUtils.modifyComponent(this.getExpr().getArray(event), mode, DataComponentTypes.DYED_COLOR, dyedItemColor);
    }

    protected String getPropertyName() {
        return "dyed color component";
    }

    public Class<? extends ch.njol.skript.util.Color> getReturnType() {
        return ch.njol.skript.util.Color.class;
    }

    static {
        ExprDyedColorComponent.register(ExprDyedColorComponent.class, ch.njol.skript.util.Color.class, (String)"dyed color [component]", (String)"itemstacks/itemtypes/slots");
    }
}

