/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.shanebeestudios.skbee.api.registry.KeyUtils;
import com.shanebeestudios.skbee.api.util.ItemComponentUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import net.kyori.adventure.key.Key;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Item Model")
@Description(value={"Represents the item model component of an item.", "See [**ItemModel**](https://minecraft.wiki/w/Data_component_format#item_model) on McWiki for more details.", "Requires Paper 1.21.3+", "", "**Changers**:", "`set` = Will set the item model of the item.", "`delete` = Will delete the item model of this item.", "`reset` = Will reset the item model back to the vanilla value."})
@Examples(value={"set {_model} to item model of player's tool", "set item model of player's tool to \"minecraft:diamond_sword\"", "set item model of {_item} to \"my_pack:some_cool_model\"", "reset item model of player's tool", "delete item model of {_item}"})
@Since(value={"3.8.0"})
public class ExprItemModel
extends SimplePropertyExpression<Object, String> {
    @Nullable
    public String convert(Object from) {
        Key data;
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(from);
        if (itemStack != null && itemStack.hasData((DataComponentType)DataComponentTypes.ITEM_MODEL) && (data = (Key)itemStack.getData(DataComponentTypes.ITEM_MODEL)) != null) {
            return data.toString();
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            case SET: 
            case DELETE: 
            case RESET: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = String.class;
                break;
            }
            default: {
                classArray = null;
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        String s;
        Object object;
        String string = delta != null && (object = delta[0]) instanceof String ? (s = (String)object) : null;
        Key key = KeyUtils.getKey(string);
        ItemComponentUtils.modifyComponent(this.getExpr().getArray(event), mode, DataComponentTypes.ITEM_MODEL, key);
    }

    protected String getPropertyName() {
        return "item model";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprItemModel.register(ExprItemModel.class, String.class, (String)"item model", (String)"itemstacks/itemtypes/slots");
    }
}

