/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.EffectSection;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.registry.KeyUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.key.Key;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="ItemComponent - Consumable Component Apply")
@Description(value={"Apply a consumable component to an item.", "If present, this item can be consumed by the player.", "Requires Paper 1.21.3+", "See [**Consumable Component**](https://minecraft.wiki/w/Data_component_format#consumable) on McWiki for more info.", "**Entries**:", "- `consume_seconds` = The amount of time it takes for a player to consume the item. Defaults to 1.6 seconds. [Optional]", "- `animation` = The animation used during consumption of the item. [Optional]", "  Must be one of \"none\", \"eat\", \"drink\", \"block\", \"bow\", \"spear\", \"crossbow\", \"spyglass\", \"toot_horn\" or \"brush\". Defaults to \"eat\"]", "- `sound` = A sound key to player when consumed. Defaults to \"entity.generic.eat\" [Optional]", "- `has_consume_particles` = Whether consumption particles are emitted while consuming this item. Defaults to true. [Optional]", "- `on_consume_effect` = A `consume effect` to by applied to the component (supports a list) [Optional].", "- `on_consume_effects` = A section to apply `consume effects` [Optional]."})
@Examples(value={"apply consumable to {_i}:", "\tanimation: \"drink\"", "\tconsume_seconds: 2.5 seconds", "\ton_consume_effects:", "\t\tapply -> potion effect of slowness for 10 seconds with probability 0.5", "\t\tapply -> clear all effects", "\t\tapply -> remove effects night vision", "\t\tapply -> play sound \"blah.blah\"", "\t\tapply -> teleport randomly within 15", "\t\tapply -> teleport randomly within 20 meters", "\t\tapply -> teleport randomly within 100 blocks", "", "set {_effects} to apply_effects(potion effect of night vision for 10 seconds, 0.5)", "set {_i} to 1 of stick", "apply consumable component to {_i}:", "\tconsume_seconds: 3.2 seconds", "\tanimation: \"brush\"", "\tsound: \"block.stone.break\"", "\thas_consume_particles: false", "\ton_consume_effect: {_effects}", "give {_i} to player"})
@Since(value={"3.8.0"})
public class SecConsumableComponent
extends EffectSection {
    private static final EntryValidator VALIDATOR = SimpleEntryValidator.builder().addOptionalEntry("consume_seconds", Timespan.class).addOptionalEntry("animation", String.class).addOptionalEntry("sound", String.class).addOptionalEntry("has_consume_particles", Boolean.class).addOptionalEntry("on_consume_effect", ConsumeEffect.class).addOptionalSection("on_consume_effects").build();
    private Expression<Object> items;
    private Expression<Timespan> consumeSeconds;
    private Expression<String> animation;
    private Expression<String> sound;
    private Expression<Boolean> hasConsumeParticles;
    private Expression<ConsumeEffect> onConsumeEffect;
    private Trigger onConsumeEffectsSection;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, @Nullable SectionNode sectionNode, @Nullable List<TriggerItem> triggerItems) {
        this.items = exprs[0];
        if (sectionNode == null) {
            return true;
        }
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.consumeSeconds = (Expression)container.getOptional("consume_seconds", false);
        this.animation = (Expression)container.getOptional("animation", false);
        this.sound = (Expression)container.getOptional("sound", false);
        this.hasConsumeParticles = (Expression)container.getOptional("has_consume_particles", false);
        this.onConsumeEffect = (Expression)container.getOptional("on_consume_effect", false);
        SectionNode effectsNode = (SectionNode)container.getOptional("on_consume_effects", SectionNode.class, false);
        if (effectsNode != null) {
            this.onConsumeEffectsSection = this.loadCode(effectsNode, "on_consume_effects", new Class[]{ConsumeEffectsEvent.class});
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        String soundString;
        Key key;
        Consumable.Builder builder = Consumable.consumable();
        if (this.consumeSeconds != null) {
            Timespan timespan = this.consumeSeconds.getOptionalSingle(event).orElse(new Timespan(1600L));
            builder.consumeSeconds((float)timespan.getAs(Timespan.TimePeriod.MILLISECOND) / 1000.0f);
        }
        if (this.animation != null) {
            String animation = this.animation.getOptionalSingle(event).orElse("eat");
            ItemUseAnimation itemUseAnimation = SecConsumableComponent.getAnimation(animation);
            builder.animation(itemUseAnimation);
        }
        if (this.sound != null && (key = KeyUtils.getKey(soundString = this.sound.getOptionalSingle(event).orElse("entity.generic.eat"))) != null) {
            builder.sound(key);
        }
        if (this.hasConsumeParticles != null) {
            ConsumeEffect[] hasConsumeParticles = this.hasConsumeParticles.getOptionalSingle(event).orElse(true);
            builder.hasConsumeParticles(hasConsumeParticles.booleanValue());
        }
        if (this.onConsumeEffect != null) {
            for (ConsumeEffect consumeEffect : (ConsumeEffect[])this.onConsumeEffect.getArray(event)) {
                builder.addEffect(consumeEffect);
            }
        }
        if (this.onConsumeEffectsSection != null) {
            ConsumeEffectsEvent consumeEffectsEvent = new ConsumeEffectsEvent(builder);
            Variables.setLocalVariables((Event)consumeEffectsEvent, (Object)Variables.copyLocalVariables((Event)event));
            Trigger.walk((TriggerItem)this.onConsumeEffectsSection, (Event)consumeEffectsEvent);
            Variables.setLocalVariables((Event)event, (Object)Variables.copyLocalVariables((Event)consumeEffectsEvent));
            Variables.copyLocalVariables((Event)consumeEffectsEvent);
        }
        Consumable consumable = (Consumable)builder.build();
        ItemUtils.modifyItems(this.items.getArray(event), itemStack -> itemStack.setData(DataComponentTypes.CONSUMABLE, (Object)consumable));
        return super.walk(event, false);
    }

    public String toString(Event e, boolean d) {
        return "apply consumable component to " + this.items.toString(e, d);
    }

    private static ItemUseAnimation getAnimation(String string) {
        string = string.replace(" ", "_").toUpperCase(Locale.ROOT);
        try {
            return ItemUseAnimation.valueOf((String)string);
        }
        catch (IllegalArgumentException e) {
            return ItemUseAnimation.EAT;
        }
    }

    static {
        Skript.registerSection(SecConsumableComponent.class, (String[])new String[]{"apply consumable [component] to %itemstacks/itemtypes/slots%"});
    }

    public static class ConsumeEffectsEvent
    extends Event {
        private final Consumable.Builder builder;

        public ConsumeEffectsEvent(Consumable.Builder builder) {
            this.builder = builder;
        }

        public Consumable.Builder getConsumableBuilder() {
            return this.builder;
        }

        @NotNull
        public HandlerList getHandlers() {
            throw new IllegalStateException("ConsumeEffectsEvent should never be called");
        }
    }
}

