/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.JukeboxPlayable;
import java.util.List;
import org.bukkit.JukeboxSong;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="ItemComponent - JukeboxPlayable Component Apply")
@Description(value={"Apply an jukebox playable component to an item.", "When applied, the item can be inserted into a jukebox and plays the specified song.", "Requires Paper 1.21.3+", "See [**JukeboxPlayable Component**](https://minecraft.wiki/w/Data_component_format#jukebox_playable) on McWiki for more info.", "", "**Entries**:", "- `song` = A jukebox song to be played."})
@Examples(value={""})
@Since(value={"3.8.0"})
public class SecJukeboxPlayableComponent
extends Section {
    private static final EntryValidator VALIDATOR = SimpleEntryValidator.builder().addRequiredEntry("song", JukeboxSong.class).build();
    private Expression<?> items;
    private Expression<JukeboxSong> jukeboxSong;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        this.items = exprs[0];
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.jukeboxSong = (Expression)container.getOptional("song", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        JukeboxSong jukeboxSong = (JukeboxSong)this.jukeboxSong.getSingle(event);
        if (jukeboxSong == null) {
            this.error("No jukebox song found");
            return super.walk(event, false);
        }
        JukeboxPlayable jukeboxPlayable = (JukeboxPlayable)JukeboxPlayable.jukeboxPlayable((JukeboxSong)jukeboxSong).build();
        ItemUtils.modifyItems(this.items.getArray(event), itemStack -> itemStack.setData(DataComponentTypes.JUKEBOX_PLAYABLE, (Object)jukeboxPlayable));
        return super.walk(event, false);
    }

    public String toString(@Nullable Event e, boolean d) {
        return "apply jukebox playable component to " + this.items.toString(e, d);
    }

    static {
        Skript.registerSection(SecJukeboxPlayableComponent.class, (String[])new String[]{"apply jukebox playable [component] to %itemstacks/itemtypes/slots%"});
    }
}

