/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.skript.base.Condition;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NBT - Has Tag")
@Description(value={"Check if an NBT Compound contains a tag."})
@Examples(value={"if nbt compound of player has tag \"custom;points\":", "if nbt compound of player's tool doesn't have nbt tag \"health;score\":"})
@Since(value={"2.3.2"})
public class CondHasNBTTag
extends Condition {
    private Expression<NBTCompound> compounds;
    private Expression<String> tag;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.compounds = exprs[0];
        this.tag = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        String tag = (String)this.tag.getSingle(event);
        if (tag == null) {
            return false;
        }
        return this.compounds.check(event, compound -> NBTApi.hasTag(compound, tag), this.isNegated());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String has = this.isNegated() ? " has tag " : " doesn't have tag ";
        return this.compounds.toString(e, d) + has + this.tag.toString(e, d);
    }

    static {
        PropertyCondition.register(CondHasNBTTag.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"[nbt] tag %string%", (String)"nbtcompounds");
    }
}

