/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTFile;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import java.io.IOException;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NBT - Save File")
@Description(value={"Manually save the NBT from a file. When getting the NBT compound from a file, changing values in the compound will", "not be automatically applied to the file, and saving will have to be done manually."})
@Examples(value={"set {_n} to nbt compound from file \"plugins/maScript/some-data.nbt\"", "set tag \"ma-tag\" of {_n} to 32", "save nbt file of {_n}"})
@Since(value={"1.14.0"})
public class EffSaveNBTFile
extends Effect {
    private Expression<NBTCompound> nbtCompound;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.nbtCompound = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        for (NBTCompound compound : (NBTCompound[])this.nbtCompound.getArray(event)) {
            if (!(compound instanceof NBTFile)) continue;
            NBTFile nbtFile = (NBTFile)compound;
            try {
                nbtFile.save();
            }
            catch (IOException ex) {
                if (SkBee.isDebug()) {
                    throw new SkriptAPIException(ex.getMessage(), (Throwable)ex);
                }
                this.error("Could not save file: '" + nbtFile.getName() + "', got error '" + ex.getMessage() + "'. Enable debug in SkBee config for more detailed error.");
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "save nbt file for " + this.nbtCompound.toString(e, d);
    }

    static {
        Skript.registerEffect(EffSaveNBTFile.class, (String[])new String[]{"save nbt file[s] (from|for|of) %nbtcompounds%"});
    }
}

