/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="NBT - Tag Delete")
@Description(value={"Delete an NBT tag without having to specify a tag type."})
@Examples(value={"delete tag \"minecraft:enchantments\" of nbt of player's tool", "delete tag \"custom;level\" of nbt of player"})
@Since(value={"3.5.0"})
public class EffTagDelete
extends Effect {
    private Expression<String> tags;
    private Expression<NBTCompound> nbt;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.tags = exprs[0];
        this.nbt = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        NBTCompound nbt = (NBTCompound)this.nbt.getSingle(event);
        if (nbt == null) {
            return;
        }
        for (String tag : (String[])this.tags.getArray(event)) {
            NBTApi.deleteTag(tag, nbt);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "delete tag[s] " + this.tags.toString(e, d) + " of " + this.nbt.toString(e, d);
    }

    static {
        Skript.registerEffect(EffTagDelete.class, (String[])new String[]{"delete tag[s] %strings% of %nbtcompound%"});
    }
}

