/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTItem;
import com.shanebeestudios.skbee.api.skript.base.PropertyExpression;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Name(value="NBT - Item from NBT")
@Description(value={"This expression allows you to grab an item from NBT compounds.", "This can be useful when wanting to grab items from file nbt, or nbt of an entity or an inventory holding block (like a chest or furnace).", "It can also be useful for creating your own serializing system.", "NOTE: Items previously serialized in MC versions 1.20.4 and below, will properly upgrade for MC 1.20.5."})
@Examples(value={"set {_nbt::*} to compound list tag \"Inventory\" of file nbt of \"world/playerdata/some-players-uuid.dat\"", "loop {_nbt::*}", "\tset {_i} to item from nbt loop-value"})
@Since(value={"1.4.10"})
public class ExprItemFromNBT
extends PropertyExpression<NBTCompound, ItemType> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean i, @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected ItemType @NotNull [] get(@NotNull Event event, NBTCompound @NotNull [] source) {
        return (ItemType[])this.get(source, nbtCompound -> {
            ItemStack itemStack;
            if (nbtCompound.hasTag("id") && (itemStack = NBTItem.convertNBTtoItem(nbtCompound)) != null) {
                return new ItemType(itemStack);
            }
            return null;
        });
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "item from nbt " + this.getExpr().toString(e, d);
    }

    static {
        Skript.registerExpression(ExprItemFromNBT.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"item[s] (from|of) nbt[s] %nbtcompounds%", "nbt item[s] (from|of) %nbtcompounds%"});
    }
}

