/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.types;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.yggdrasil.Fields;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import com.shanebeestudios.skbee.api.nbt.NBTCustomType;
import com.shanebeestudios.skbee.api.nbt.NBTFile;
import com.shanebeestudios.skbee.api.nbt.NbtApiException;
import java.io.StreamCorruptedException;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkriptTypes {
    public static final Changer<NBTCompound> NBT_COMPOUND_CHANGER = new Changer<NBTCompound>(){

        @Nullable
        public @Nullable Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
            return switch (mode) {
                case Changer.ChangeMode.ADD -> (Class[])CollectionUtils.array((Object[])new Class[]{NBTCompound.class});
                case Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
                default -> null;
            };
        }

        public void change(NBTCompound[] what, @Nullable Object[] delta, Changer.ChangeMode mode) {
            block3: {
                block2: {
                    NBTCompound[] nBTCompoundArray;
                    if (mode != Changer.ChangeMode.ADD || !((nBTCompoundArray = delta[0]) instanceof NBTCompound)) break block2;
                    NBTCompound changer = (NBTCompound)nBTCompoundArray;
                    for (NBTCompound nbtCompound : what) {
                        nbtCompound.mergeCompound(changer);
                    }
                    break block3;
                }
                if (mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET) break block3;
                for (NBTCompound nbtCompound : what) {
                    nbtCompound.clearNBT();
                    if (!(nbtCompound instanceof NBTFile)) continue;
                    NBTFile nbtFile = (NBTFile)nbtCompound;
                    if (mode != Changer.ChangeMode.DELETE) continue;
                    nbtFile.getFile().delete();
                }
            }
        }
    };
    private static final String NBT_EMPTY;

    private static String getNBTString(@NotNull NBTCompound nbtCompound) {
        try {
            return nbtCompound.toString();
        }
        catch (NbtApiException ignore) {
            return NBT_EMPTY;
        }
    }

    static {
        Classes.registerClass((ClassInfo)new ClassInfo(NBTCustomType.class, "nbttype").user(new String[]{"nbt ?types?"}).name("NBT - Tag Type").description(new String[]{"Represents a type of NBT tag.", "You can read more about NBT types:", "\nMcWiki [**NBT Data Types**](https://minecraft.wiki/w/NBT_format#Data_types)", "\nSkBee Wiki [**NBT Data Types**](https://github.com/ShaneBeee/SkBee/wiki/NBT-Intro#datatypes-in-nbt)"}).usage(new String[]{NBTCustomType.getNames()}).examples(new String[]{"set byte tag \"points\" of {_nbt} to 1", "set compound tag \"tool\" of {_nbt} to nbt compound of player's tool"}).since("1.10.0").parser((Parser)new Parser<NBTCustomType>(){

            @Nullable
            public NBTCustomType parse(String s, ParseContext context) {
                return NBTCustomType.fromName(s);
            }

            public String toString(NBTCustomType nbtCustomType, int i) {
                return nbtCustomType.getName();
            }

            public String toVariableNameString(NBTCustomType nbtCustomType) {
                return this.toString(nbtCustomType, 0);
            }

            public String getVariableNamePattern() {
                return "\\S";
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(NBTCompound.class, "nbtcompound").user(new String[]{"nbt ?(compounds?)?"}).name("NBT - Compound").description(new String[]{"Represents the NBT compound of an entity/block/item/file/string.", "NBT compounds can be merged by adding together, see examples."}).usage(new String[]{"{id:\"minecraft:netherite_axe\",tag:{Damage:0,Enchantments:[{id:\"minecraft:unbreaking\",lvl:2s}]},Count:1b}"}).examples(new String[]{"set {_a} to nbt compound of player", "set {_nbt} to nbt compound of last spawned entity", "set {_n} to nbt compound from \"{Invisible:1b}\"", "add {_n} to nbt of target entity"}).since("1.6.0").parser((Parser)new Parser<NBTCompound>(){

            public boolean canParse(@NotNull ParseContext context) {
                return false;
            }

            public String toString(@NotNull NBTCompound nbt, int flags) {
                if (!Bukkit.isPrimaryThread() && !SkBee.getPlugin().getPluginConfig().NBT_ALLOW_UNSAFE_OPERATIONS) {
                    Skript.error((String)"NBT cannot be converted to a string off the main thread.");
                    return null;
                }
                return SkriptTypes.getNBTString(nbt);
            }

            public String toVariableNameString(@NotNull NBTCompound nbt) {
                return "nbt:" + this.toString(nbt, 0);
            }
        }).serializer((Serializer)new Serializer<NBTCompound>(){

            @NotNull
            public Fields serialize(@NotNull NBTCompound nbt) {
                Fields fields = new Fields();
                fields.putObject("nbt", (Object)SkriptTypes.getNBTString(nbt));
                return fields;
            }

            public void deserialize(@NotNull NBTCompound o, @NotNull Fields f) {
                assert (false);
            }

            protected NBTCompound deserialize(@NotNull Fields fields) throws StreamCorruptedException {
                String nbt = (String)fields.getObject("nbt", String.class);
                if (nbt == null) {
                    throw new StreamCorruptedException("NBT string is null");
                }
                try {
                    return new NBTContainer(nbt);
                }
                catch (Exception ex) {
                    throw new StreamCorruptedException("Invalid nbt data: " + nbt);
                }
            }

            public boolean mustSyncDeserialization() {
                return true;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        }).changer(NBT_COMPOUND_CHANGER));
        NBT_EMPTY = new NBTContainer("{}").toString();
    }
}

