/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Block Can Random Tick")
@Description(value={"Gets if this block is ticked randomly in the world. The blocks current state may change this value.", "Requires Paper 1.19+"})
@Examples(value={"on right click:", "\tif clicked block can random tick:", "\t\trandom tick clicked block"})
@Since(value={"3.0.0"})
public class CondBlockCanRandomTick
extends Condition {
    private Expression<?> blocks;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.methodExists(Block.class, (String)"randomTick", (Class[])new Class[0])) {
            Skript.error((String)"`can random tick` condition requires Paper 1.19+");
            return false;
        }
        this.blocks = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(@NotNull Event event) {
        return this.blocks.check(event, object -> {
            ItemType itemType;
            Material material;
            if (object instanceof Block) {
                Block block = (Block)object;
                return block.getBlockData().isRandomlyTicked();
            }
            if (object instanceof BlockData) {
                BlockData blockData = (BlockData)object;
                return blockData.isRandomlyTicked();
            }
            if (object instanceof ItemType && (material = (itemType = (ItemType)object).getMaterial()).isBlock()) {
                return material.createBlockData().isRandomlyTicked();
            }
            return false;
        }, this.isNegated());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String can = this.isNegated() ? " cannot" : " can";
        return this.blocks.toString(e, d) + can + " random tick";
    }

    static {
        Skript.registerCondition(CondBlockCanRandomTick.class, (String[])new String[]{"%blocks/blockdatas/itemtypes% can random[ly] tick", "%blocks/blockdatas/itemtypes% (can't|cannot) random[ly] tick"});
    }
}

