/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lockable;

@Name(value="Is Locked")
@Description(value={"Check if a lockable container is in a locked state."})
@Examples(value={"on right click on shulker box or beacon:", "\tclicked block is locked", "\tplayer has permission \"see.locked\"", "\tsend action bar \"%container key of clicked block%\" to player"})
@Since(value={"2.16.0"})
public class CondIsLocked
extends PropertyCondition<Block> {
    public boolean check(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof Lockable) {
            Lockable lockable = (Lockable)blockState;
            return lockable.isLocked();
        }
        return false;
    }

    protected String getPropertyName() {
        return "locked";
    }

    static {
        CondIsLocked.register(CondIsLocked.class, (String)"locked", (String)"blocks");
    }
}

