/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.region.RegionUtils;
import com.shanebeestudios.skbee.api.skript.base.Condition;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Folia - Object Owned by Current Region")
@Description(value={"Returns whether the current thread is ticking a region and that the region being ticked owns the entity/block/location/chunk at the specified world/position as included in the specified object.", "The chunk pattern accepts Chunk X/Z, not world position.", "This is useful to check before manipulating entities/blocks/ect which may not be in the same region as the caller."})
@Examples(value={"on break:", "\tif block at location(1,1,1) is owned by current region:", "\t\tset block at location(1,1,1) to stone"})
@Since(value={"3.10.0"})
public class CondIsOwnedByRegion
extends Condition {
    private int pattern;
    private Expression<?> objects;
    private Expression<Integer> x;
    private Expression<Integer> z;
    private Expression<World> world;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setNegated(parseResult.hasTag("neg"));
        this.pattern = matchedPattern;
        if (matchedPattern == 0) {
            this.objects = exprs[0];
        } else {
            this.x = exprs[0];
            this.z = exprs[1];
            this.world = exprs[2];
        }
        return true;
    }

    public boolean check(Event event) {
        if (this.pattern == 0) {
            return this.objects.check(event, RegionUtils::isOwnedByCurrentRegion, this.isNegated());
        }
        Integer x = (Integer)this.x.getSingle(event);
        Integer z = (Integer)this.z.getSingle(event);
        if (x == null || z == null) {
            return false;
        }
        return this.world.check(event, world -> RegionUtils.isOwnedByCurrentRegion(world, x, z), this.isNegated());
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.pattern == 0) {
            String plural = this.objects.isSingle() ? "is" : "are";
            return new SyntaxStringBuilder(event, debug).append(this.objects).append(this.isNegated() ? plural + " not" : plural).append((Object)"owned by current region").toString();
        }
        return new SyntaxStringBuilder(event, debug).append(new Object[]{"chunk at", this.x, ",", this.z}).append(new Object[]{"in world", this.world}).append((Object)(this.isNegated() ? "is not" : "is")).append((Object)"owned by current region").toString();
    }

    static {
        Skript.registerCondition(CondIsOwnedByRegion.class, (String[])new String[]{"%entities/blocks/locations% (is|are)[neg:n't] owned by current region", "chunk at %integer%,[ ]%integer% (in|of) %world% is[neg:n't] owned by current region"});
    }
}

