/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Is Player Listed")
@Description(value={"Check if a player is listed (shown in PlayerList) for another player. Requires PaperMC 1.20.1+"})
@Examples(value={"if player is listed for {_p}:"})
@Since(value={"2.17.0"})
public class CondIsPlayerListed
extends Condition {
    private boolean not;
    private Expression<Player> players;
    private Expression<Player> listed;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.not = matchedPattern == 1;
        this.players = exprs[1];
        this.listed = exprs[0];
        return true;
    }

    public boolean check(Event event) {
        for (Player player : (Player[])this.players.getArray(event)) {
            for (Player listed : (Player[])this.listed.getArray(event)) {
                if (player.isListed(listed) && this.not) {
                    return false;
                }
                if (player.isListed(listed) || this.not) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String plural = this.listed.isSingle() ? " is" : " are";
        String neg = this.not ? " not" : "";
        return this.listed.toString(e, d) + plural + neg + " listed for " + this.players.toString(e, d);
    }

    static {
        if (Skript.methodExists(Player.class, (String)"isListed", (Class[])new Class[]{Player.class})) {
            Skript.registerCondition(CondIsPlayerListed.class, (String[])new String[]{"%players% (is|are) listed for %players%", "%players% (is|are)(n't| not) listed for %players%"});
        }
    }
}

