/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;

@Name(value="Spawner - Is Activated")
@Description(value={"Returns true if a player is currently within the required player range of the spawner."})
@Examples(value={"at 7:00:", "\tloop {spawners::*}:", "\t\tloop-value is activated", "\t\tbroadcast loop-value"})
@Since(value={"2.16.0"})
public class CondSpawnerIsActivated
extends PropertyCondition<Block> {
    public boolean check(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            return spawner.isActivated();
        }
        return false;
    }

    protected String getPropertyName() {
        return "activated";
    }

    static {
        CondSpawnerIsActivated.register(CondSpawnerIsActivated.class, (String)"activated", (String)"blocks");
    }
}

