/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lockable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Name(value="Apply Lock to Block")
@Description(value={"Apply an item as a lock for a block. Requires Minecraft 1.21.2+"})
@Examples(value={"apply lock to target block using player's tool", "apply lock to {_blocks::*} using stick named \"Mr Locky\"", "remove lock from target block"})
@Since(value={"3.6.2"})
public class EffBlockLock
extends Effect {
    private Expression<Block> blocks;
    private Expression<ItemStack> item;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blocks = exprs[0];
        if (matchedPattern == 0) {
            this.item = exprs[1];
        }
        return true;
    }

    protected void execute(Event event) {
        ItemStack itemStack = this.item != null ? (ItemStack)this.item.getSingle(event) : null;
        for (Block block : (Block[])this.blocks.getArray(event)) {
            BlockState state = block.getState();
            if (state instanceof Lockable) {
                Lockable lockable = (Lockable)state;
                lockable.setLockItem(itemStack);
                state.update(true);
                continue;
            }
            this.error("Block is not lockable: " + Classes.toString((Object)block.getType()));
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        if (this.item == null) {
            return "remove lock from " + this.blocks.toString(e, d);
        }
        return "apply lock to " + this.blocks.toString(e, d) + " using " + this.item.toString(e, d);
    }

    static {
        if (Util.IS_RUNNING_MC_1_21_2) {
            Skript.registerEffect(EffBlockLock.class, (String[])new String[]{"apply lock to %blocks% using %itemstack%", "(remove|clear) lock (of|from) %blocks%"});
        }
    }
}

