/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Random Tick Block")
@Description(value={"Causes the block to be ticked randomly.", "This will tick the block the same way Minecraft randomly ticks according to the randomTickSpeed gamerule.", "Requires Paper 1.19+"})
@Examples(value={"random tick blocks in radius 3 around target block"})
@Since(value={"3.0.0"})
public class EffBlockRandomlyTick
extends Effect {
    private Expression<Block> blocks;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.methodExists(Block.class, (String)"randomTick", (Class[])new Class[0])) {
            Skript.error((String)"`random tick` effect requires Paper 1.19+");
            return false;
        }
        this.blocks = exprs[0];
        return true;
    }

    protected void execute(@NotNull Event event) {
        for (Block block : (Block[])this.blocks.getArray(event)) {
            block.randomTick();
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "randomly tick " + this.blocks.toString(e, d);
    }

    static {
        Skript.registerEffect(EffBlockRandomlyTick.class, (String[])new String[]{"random[ly] tick %blocks%"});
    }
}

