/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.paperlib.PaperLib;
import ch.njol.skript.variables.Variables;
import ch.njol.skript.variables.VariablesMap;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Chunk - Load/Unload")
@Description(value={"Load or unload a chunk.", "**Options**:", "- `%number%,[ ]%number%` = Represents the X/Z coords of a chunk. Not to be confused with a location. Chunk coords are essentially a location divided by 16, example: Chunk 1/1 = Location 16/16", "- `async` = Will load the chunk off the main thread (Requires PaperMC). Your code will halt whilst waiting for the chunk to load.", "- `with ticket` = Will add a ticket to the chunk, preventing it from unloading until you explicitly unload it or the server stops.", "- `without saving` = Will prevent the chunk from saving when unloading."})
@Examples(value={"load chunk at 1,1 in world \"world\"", "load chunk at location(1,1,1, world \"world\")", "load chunk at 150,150 in world \"world\"", "load chunk at 150,150 in world \"world\" with ticket", "async load chunk at {_loc}", "async load chunk at 100,100 in world \"world\"", "async load chunk at 1,1 in world of player with ticket", "unload chunk at 1,1 in world \"world\""})
@Since(value={"1.17.0, 2.11.0 (async)"})
public class EffLoadChunk
extends Effect {
    private static final SkBee PLUGIN = SkBee.getPlugin();
    private int pattern;
    private boolean ticket;
    private boolean unload;
    private boolean isAsync;
    private boolean save;
    private Expression<Number> x;
    private Expression<Number> z;
    private Expression<World> world;
    private Expression<Location> location;
    private Expression<Chunk> chunks;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = pattern;
        this.unload = pattern != 0 && pattern != 2;
        this.ticket = parseResult.hasTag("ticket");
        this.isAsync = parseResult.hasTag("async");
        boolean bl = this.save = !parseResult.hasTag("nosave");
        if (pattern <= 1) {
            this.x = exprs[0];
            this.z = exprs[1];
            this.world = exprs[2];
        } else if (pattern <= 3) {
            this.location = exprs[0];
        } else {
            this.chunks = exprs[0];
        }
        return true;
    }

    protected void execute(Event event) {
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        TriggerItem next;
        block10: {
            block8: {
                World world;
                int z;
                int x;
                block9: {
                    Location location;
                    next = this.getNext();
                    if (this.pattern >= 4) break block8;
                    x = 0;
                    z = 0;
                    world = (World)Bukkit.getWorlds().getFirst();
                    if (this.x != null) {
                        Number xSingle = (Number)this.x.getSingle(event);
                        if (xSingle == null) {
                            return next;
                        }
                        x = xSingle.intValue();
                    }
                    if (this.z != null) {
                        Number zSingle = (Number)this.z.getSingle(event);
                        if (zSingle == null) {
                            return next;
                        }
                        z = zSingle.intValue();
                    }
                    if (this.world != null && (world = (World)this.world.getSingle(event)) == null) {
                        return next;
                    }
                    if (this.location != null && (location = (Location)this.location.getSingle(event)) != null) {
                        x = location.getBlockX() >> 4;
                        z = location.getBlockZ() >> 4;
                        world = location.getWorld();
                    }
                    if (!this.unload) break block9;
                    world.removePluginChunkTicket(x, z, (Plugin)PLUGIN);
                    world.unloadChunk(x, z, this.save);
                    break block10;
                }
                if (this.isAsync) {
                    VariablesMap localVars = Variables.removeLocals((Event)event);
                    PaperLib.getChunkAtAsync((World)world, (int)x, (int)z).thenAccept(chunk -> {
                        if (this.ticket) {
                            chunk.addPluginChunkTicket((Plugin)PLUGIN);
                        }
                        if (localVars != null) {
                            Variables.setLocalVariables((Event)event, (Object)localVars);
                        }
                        if (next != null) {
                            TriggerItem.walk((TriggerItem)next, (Event)event);
                        }
                        Variables.removeLocals((Event)event);
                    });
                    return null;
                }
                world.getChunkAt(x, z);
                if (!this.ticket) break block10;
                world.addPluginChunkTicket(x, z, (Plugin)PLUGIN);
                break block10;
            }
            for (Chunk chunk2 : (Chunk[])this.chunks.getArray(event)) {
                chunk2.removePluginChunkTicket((Plugin)PLUGIN);
                chunk2.unload(this.save);
            }
        }
        return next;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        Object chunk;
        String load = this.unload ? "unload" : (this.isAsync ? "async " : "") + "load";
        switch (this.pattern) {
            case 2: 
            case 3: {
                Object object = "at " + this.location.toString(e, d);
                break;
            }
            case 4: {
                Object object = this.chunks.toString(e, d);
                break;
            }
            default: {
                Object object = chunk = "at " + this.x.toString(e, d) + "," + this.z.toString(e, d);
            }
        }
        String ticket = this.ticket ? " with ticket" : (!this.save ? " witout saving" : "");
        return String.format("%s chunk %s %s", load, chunk, ticket);
    }

    static {
        Skript.registerEffect(EffLoadChunk.class, (String[])new String[]{"[:async] load chunk at %number%,[ ]%number% (in|of) [world] %world% [ticket:with ticket]", "unload chunk at %number%,[ ]%number% (in|of) [world] %world%", "[:async] load chunk at %location% [ticket:with ticket]", "unload chunk at %location% [nosave:without saving]", "unload %chunks% [nosave:without saving]"});
    }
}

