/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="LootTable - Fill Inventory")
@Description(value={"Fill an inventory with a predefined LootTable.", "This inventory must belong to a block or entity (custom inventories will not work).", "Optionals:", "Some loot tables will require some of these values whereas others may not.", "`seed` = Represents the random seed used to generate loot (if not provided will generate randomly).", "`looting modifier` = Set the looting enchant level equivalent to use when generating loot.", "Values less than or equal to 0 will force the LootTable to only return a single Item per pool.", "`luck` = How much luck to have when generating loot.", "`killer/looter` = The Player that killed/looted. This Player will be used to get the looting level if looting modifier is not set.", "`looted entity` = The Entity that was killed/looted."})
@Examples(value={"set {_loottable} to loottable from key \"minecraft:chests/ancient_city\"", "fill inventory of target block from {_loottable}", "fill inventory of player from (loottable from key \"minecraft:gameplay/fishing\")"})
@Since(value={"3.4.0"})
public class EffLootTableFillInv
extends Effect {
    private Expression<Inventory> inventories;
    private Expression<LootTable> lootTable;
    private Expression<Number> seed;
    private Expression<Number> lootingModifier;
    private Expression<Number> luck;
    private Expression<Player> killer;
    private Expression<Entity> lootedEntity;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.inventories = exprs[0];
        this.lootTable = exprs[1];
        this.seed = exprs[2];
        this.lootingModifier = exprs[3];
        if (Util.IS_RUNNING_MC_1_21 && this.lootingModifier != null) {
            Skript.error((String)"'with looting modifier' is no longer functional!");
            return false;
        }
        this.luck = exprs[4];
        this.killer = exprs[5];
        this.lootedEntity = exprs[6];
        return true;
    }

    protected void execute(Event event) {
        Entity lootedEntity;
        LootTable lootTable = (LootTable)this.lootTable.getSingle(event);
        Number seed = this.seed != null ? (Number)((Number)this.seed.getSingle(event)) : (Number)null;
        Number lootingModifier = this.lootingModifier != null ? (Number)((Number)this.lootingModifier.getSingle(event)) : (Number)null;
        Number luck = this.luck != null ? (Number)((Number)this.luck.getSingle(event)) : (Number)null;
        Player killer = this.killer != null ? (Player)this.killer.getSingle(event) : null;
        Entity entity = lootedEntity = this.lootedEntity != null ? (Entity)this.lootedEntity.getSingle(event) : null;
        if (lootTable == null) {
            return;
        }
        for (Inventory inventory : (Inventory[])this.inventories.getArray(event)) {
            Location location = inventory.getLocation();
            if (location == null) continue;
            Random random = seed != null ? new Random(seed.longValue()) : new Random();
            LootContext.Builder builder = new LootContext.Builder(location);
            if (lootingModifier != null) {
                builder.lootingModifier(lootingModifier.intValue());
            }
            if (luck != null) {
                builder.luck(luck.floatValue());
            }
            if (killer != null) {
                builder.killer((HumanEntity)killer);
            } else if (inventory instanceof PlayerInventory) {
                PlayerInventory playerInventory = (PlayerInventory)inventory;
                builder.killer(playerInventory.getHolder());
            }
            if (lootedEntity != null) {
                builder.lootedEntity(lootedEntity);
            }
            try {
                lootTable.fillInventory(inventory, random, builder.build());
            }
            catch (IllegalArgumentException ex) {
                if (!SkBee.isDebug()) continue;
                ex.printStackTrace();
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String inv = this.inventories.toString(e, d);
        String lootTable = this.lootTable.toString(e, d);
        String seed = this.seed != null ? " with seed " + this.seed.toString(e, d) : "";
        String mod = this.lootingModifier != null ? " with lootiing modifier " + this.lootingModifier.toString(e, d) : "";
        String luck = this.luck != null ? " with luck " + this.luck.toString(e, d) : "";
        String killer = this.killer != null ? " with killer " + this.killer.toString(e, d) : "";
        String looted = this.lootedEntity != null ? " with looted entity " + this.lootedEntity.toString(e, d) : "";
        return String.format("fill %s from %s %s%s%s%s%s", inv, lootTable, seed, mod, luck, killer, looted);
    }

    static {
        Skript.registerEffect(EffLootTableFillInv.class, (String[])new String[]{"fill %inventories% from %loottable% [with seed %-number%] [with looting modifier %-number%] [with luck %-number%] [with (killer|looter) %-player%] [with looted entity %-entity%]"});
    }
}

