/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtDamageByBlock
extends SkriptEvent {
    private Literal<EntityData<?>> entityType;
    private Literal<?> blockType;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.entityType = args[0];
        this.blockType = args[1];
        return true;
    }

    public boolean check(Event event) {
        if (event instanceof EntityDamageByBlockEvent) {
            EntityDamageByBlockEvent damageEvent = (EntityDamageByBlockEvent)event;
            return this.checkDamaged(damageEvent.getEntity()) && this.checkDamager(damageEvent.getDamager());
        }
        return false;
    }

    private boolean checkDamaged(Entity entity) {
        if (this.entityType != null) {
            for (EntityData entityData : (EntityData[])this.entityType.getAll()) {
                if (!entityData.isInstance(entity)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean checkDamager(Block block) {
        if (this.blockType != null) {
            BlockData data = block.getBlockData();
            for (Object object : this.blockType.getAll()) {
                BlockData blockData;
                ItemType itemType;
                if (!(object instanceof ItemType ? (itemType = (ItemType)object).isOfType(block) : object instanceof BlockData && data.matches(blockData = (BlockData)object))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String entity = this.entityType != null ? " of " + this.entityType.toString(e, d) : "";
        String block = this.blockType != null ? this.blockType.toString(e, d) : "block";
        return "damage" + entity + " by " + block;
    }

    static {
        Skript.registerEvent((String)"Damage By Block", EvtDamageByBlock.class, EntityDamageByBlockEvent.class, (String[])new String[]{"damag(e|ing) [of %-entitydata%] (by|from) (block|%itemtypes/blockdatas%)"}).description(new String[]{"Called when an entity is damaged by a block.", "Anything that works in vanilla Skript's damage event (victim/damage cause/damage/final damage)", "will all work in this event too.", "\n`victim` = Same as vanilla Skript, `victim` is used to get the damaged entity.", "\n`event-block` = The block that damaged the entity"}).examples(new String[]{"on damage of player by sweet berry bush:", "\tcancel event", "", "on damage by block:", "\tbroadcast \"%victim% was damaged by %type of event-block%\""}).since("3.0.2");
        EventValues.registerEventValue(EntityDamageByBlockEvent.class, Block.class, EntityDamageByBlockEvent::getDamager, (int)0);
    }
}

