/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockData - All Variations")
@Description(value={"Returns a list of all possible blockdatas for a particular block type.", "Requires Paper 1.21.4+"})
@Examples(value={"set {_states::*} to blockdata states of oak log", "# output:", "# minecraft:oak_log[axis=x]", "# minecraft:oak_log[axis=y]", "# minecraft:oak_log[axis=z]", "loop all blockdata variations of wall torch:", "# output:", "# minecraft:wall_torch[facing=north]", "# minecraft:wall_torch[facing=south]", "# minecraft:wall_torch[facing=west]", "# minecraft:wall_torch[facing=east]"})
@Since(value={"3.8.0"})
public class ExprBlockDataAllStates
extends SimpleExpression<BlockData> {
    private Expression<?> objects;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.objects = LiteralUtils.defendExpression(exprs[0]);
        return LiteralUtils.canInitSafely((Expression[])new Expression[]{this.objects});
    }

    protected BlockData @Nullable [] get(Event event) {
        ArrayList blockDatas = new ArrayList();
        for (Object object : this.objects.getArray(event)) {
            BlockType blockType;
            Material material = null;
            if (object instanceof ItemType) {
                ItemType itemType = (ItemType)object;
                material = itemType.getMaterial();
            } else if (object instanceof BlockData) {
                BlockData blockData = (BlockData)object;
                material = blockData.getMaterial();
            }
            if (material == null || !material.isBlock() || (blockType = material.asBlockType()) == null) continue;
            blockDatas.addAll(blockType.createBlockDataStates());
        }
        return blockDatas.toArray(new BlockData[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends BlockData> getReturnType() {
        return BlockData.class;
    }

    public String toString(Event e, boolean d) {
        return "all possible blockdata states of " + this.objects.toString(e, d);
    }

    static {
        if (Skript.classExists((String)"org.bukkit.block.BlockType") && Skript.methodExists(BlockType.class, (String)"createBlockDataStates", (Class[])new Class[0])) {
            Skript.registerExpression(ExprBlockDataAllStates.class, BlockData.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[all] [possible] block[ ]data (states|variations) of %itemtypes/blockdatas%"});
        }
    }
}

