/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.BlockDataUtils;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockData - Item BlockData")
@Description(value={"Get/set the BlockData that is attached to an item."})
@Examples(value={"set {_item} to a campfire", "set item blockdata of {_item} to campfire[lit=false]"})
@Since(value={"3.4.0"})
public class ExprBlockDataItem
extends SimplePropertyExpression<ItemType, BlockData> {
    @Nullable
    public BlockData convert(ItemType itemType) {
        ItemMeta itemMeta = itemType.getItemMeta();
        if (itemMeta instanceof BlockDataMeta) {
            BlockDataMeta meta = (BlockDataMeta)itemMeta;
            Material blockForm = BlockDataUtils.getBlockForm(itemType.getMaterial());
            if (blockForm != null && blockForm.isBlock()) {
                return meta.getBlockData(blockForm);
            }
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{BlockData.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        ItemType[] itemTypeArray;
        if (delta != null && (itemTypeArray = delta[0]) instanceof BlockData) {
            BlockData blockData = (BlockData)itemTypeArray;
            for (ItemType itemType : (ItemType[])this.getExpr().getAll(event)) {
                ItemMeta itemMeta = itemType.getItemMeta();
                if (!(itemMeta instanceof BlockDataMeta)) continue;
                BlockDataMeta itemMeta2 = (BlockDataMeta)itemMeta;
                itemMeta2.setBlockData(blockData);
                itemType.setItemMeta((ItemMeta)itemMeta2);
            }
        }
    }

    @NotNull
    public Class<BlockData> getReturnType() {
        return BlockData.class;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    protected String getPropertyName() {
        return "item blockdata";
    }

    static {
        PropertyExpression.register(ExprBlockDataItem.class, BlockData.class, (String)"item [block[ ]](data|state)", (String)"itemtypes");
    }
}

