/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.BlockDataUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockData - Item BlockData Tags")
@Description(value={"Get all the tags from the BlockData of an item."})
@Examples(value={"set {_tags::} to item blockdata tags of player's tool"})
@Since(value={"3.4.0"})
public class ExprBlockDataItemTags
extends SimpleExpression<String> {
    private Expression<ItemType> itemTypes;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemTypes = exprs[0];
        return true;
    }

    @Nullable
    protected String[] get(Event event) {
        ArrayList<String> tags = new ArrayList<String>();
        for (ItemType itemType : (ItemType[])this.itemTypes.getArray(event)) {
            BlockData blockData;
            String[] data;
            ItemMeta itemMeta = itemType.getItemMeta();
            if (!(itemMeta instanceof BlockDataMeta)) continue;
            BlockDataMeta blockDataMeta = (BlockDataMeta)itemMeta;
            Material blockForm = BlockDataUtils.getBlockForm(itemType.getMaterial());
            if (blockForm == null || !blockForm.isBlock() || (data = BlockDataUtils.getBlockDataTags(blockData = blockDataMeta.getBlockData(blockForm))) == null) continue;
            tags.addAll(Arrays.asList(data));
        }
        return tags.toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "item blockdata tags of " + this.itemTypes.toString(e, d);
    }

    static {
        PropertyExpression.register(ExprBlockDataItemTags.class, String.class, (String)"item [block[ ]](data|state) tags", (String)"itemtypes");
    }
}

